/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.path;

import java.util.ArrayList;
import org.basex.data.Data;
import org.basex.index.path.PathNode;
import org.basex.index.stats.Stats;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Filter;
import org.basex.query.expr.Pos;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeIter;
import org.basex.query.iter.NodeSeqBuilder;
import org.basex.query.path.Axis;
import org.basex.query.path.AxisStep;
import org.basex.query.path.InvDocTest;
import org.basex.query.path.IterPath;
import org.basex.query.path.Path;
import org.basex.query.path.Test;
import org.basex.query.util.Err;
import org.basex.query.util.IndexContext;
import org.basex.query.util.Var;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.util.Array;
import org.basex.util.InputInfo;

public class AxisPath
extends Path {
    private boolean cache;
    private NodeSeqBuilder citer;
    private Value lvalue;

    AxisPath(InputInfo ii, Expr r, Expr ... s) {
        super(ii, r, s);
    }

    final AxisPath finish(QueryContext ctx) {
        this.size = this.size(ctx);
        this.type = SeqType.get(this.steps[this.steps.length - 1].type().type, this.size);
        return this.useIterator() ? new IterPath(this.info, this.root, this.steps, this.type, this.size) : this;
    }

    private boolean useIterator() {
        if (this.root == null || this.root.uses(Expr.Use.VAR) || !this.root.iterable()) {
            return false;
        }
        int sl = this.steps.length;
        for (int s = 0; s < sl; ++s) {
            switch (this.step((int)s).axis) {
                case ANC: 
                case ANCORSELF: 
                case PREC: 
                case PRECSIBL: {
                    return false;
                }
                case DESC: 
                case DESCORSELF: 
                case FOLL: 
                case FOLLSIBL: {
                    return s + 1 == sl || s + 2 == sl && this.step((int)(s + 1)).axis == Axis.ATTR;
                }
            }
        }
        return true;
    }

    @Override
    protected final Expr compilePath(QueryContext ctx) throws QueryException {
        AxisStep s;
        if (this.root instanceof AxisPath) {
            Expr[] st = ((AxisPath)this.root).steps;
            this.root = ((AxisPath)this.root).root;
            for (Expr s2 : this.steps) {
                st = Array.add(st, s2);
            }
            this.steps = st;
            ctx.compInfo("merging axis paths", new Object[0]);
            ctx.value = this.root(ctx);
        }
        if ((s = this.voidStep(this.steps)) != null) {
            Err.COMPSELF.thrw(this.info, s);
        }
        for (int i = 0; i != this.steps.length; ++i) {
            Expr e = this.steps[i].compile(ctx);
            if (!(e instanceof AxisStep)) {
                return e;
            }
            this.steps[i] = e;
        }
        this.optSteps(ctx);
        Data data = ctx.data();
        if (data != null && ctx.value.type == NodeType.DOC) {
            Expr e = this.index(ctx, data);
            if (e == this) {
                e = this.children(ctx, data);
            }
            if (e != this) {
                return e.compile(ctx);
            }
        }
        this.cache = this.root != null && !this.uses(Expr.Use.VAR);
        AxisPath path = this.finish(ctx);
        return this.size() != 1L ? path : new Filter(this.info, this, Pos.get(1L, this.size(), this.info)).comp2(ctx);
    }

    private Expr index(QueryContext ctx, Data data) throws QueryException {
        if (this.root == null || this.uses(Expr.Use.POS)) {
            return this;
        }
        IndexContext ics = null;
        int pmin = 0;
        int smin = 0;
        for (int s = 0; s < this.steps.length; ++s) {
            AxisStep stp = this.step(s);
            if (!stp.axis.down) break;
            boolean i = this.pathNodes(data, s) != null;
            for (int p = 0; p < stp.preds.length; ++p) {
                IndexContext ic = new IndexContext(ctx, data, stp, i);
                if (!stp.preds[p].indexAccessible(ic)) continue;
                if (ic.costs() == 0) {
                    if (ic.not) {
                        stp.preds[p] = Bln.TRUE;
                        continue;
                    }
                    ctx.compInfo("removing path with no index results", this);
                    return Empty.SEQ;
                }
                if (ics != null && ics.costs() <= ic.costs()) continue;
                ics = ic;
                pmin = p;
                smin = s;
            }
        }
        if (ics == null || ics.costs() > data.meta.size) {
            return this;
        }
        AxisStep stp = this.step(smin);
        Expr ie = stp.preds[pmin].indexEquivalent(ics);
        if (!ics.seq) {
            AxisPath result;
            boolean simple;
            int j;
            Expr[] invSteps = new AxisStep[]{};
            Expr[] newPreds = new Expr[stp.preds.length - 1];
            int c = 0;
            for (int p = 0; p != stp.preds.length; ++p) {
                if (p == pmin) continue;
                newPreds[c++] = stp.preds[p];
            }
            Test test = InvDocTest.get(ctx, data);
            boolean inv = true;
            if (test == Test.DOC && data.meta.uptodate) {
                int name;
                ArrayList<PathNode> pn;
                AxisStep s;
                for (j = 0; j <= smin && (s = this.axisStep(j)) != null && s.test.mode == Test.Mode.NAME && s.axis == Axis.CHILD && (j == smin || s.preds.length <= 0) && (pn = data.paths.desc(name = data.tagindex.id(s.test.name.local()), 1)).size() == 1 && pn.get(0).level() == j + 1; ++j) {
                }
                boolean bl = inv = j <= smin;
            }
            if (inv) {
                Axis ax;
                for (j = smin; j >= 0 && (ax = this.step((int)j).axis.invert()) != null; --j) {
                    if (j != 0) {
                        AxisStep prev = this.step(j - 1);
                        invSteps = Array.add(invSteps, AxisStep.get(this.info, ax, prev.test, prev.preds));
                        continue;
                    }
                    if (test == Test.DOC && (ax == Axis.ANC || ax == Axis.ANCORSELF)) continue;
                    invSteps = Array.add(invSteps, AxisStep.get(this.info, ax, test, new Expr[0]));
                }
            }
            boolean bl = simple = invSteps.length == 0 && newPreds.length == 0;
            if (ie instanceof AxisPath) {
                result = (AxisPath)ie;
            } else if (smin + 1 < this.steps.length || !simple) {
                result = simple ? new AxisPath(this.info, ie, new Expr[0]) : new AxisPath(this.info, ie, AxisStep.get(this.info, Axis.SELF, Test.NOD, new Expr[0]));
            } else {
                return ie;
            }
            int ls = result.steps.length - 1;
            if (ls >= 0) {
                result.steps[ls] = result.step(ls).addPreds(newPreds);
                if (invSteps.length != 0) {
                    result.steps[ls] = result.step(ls).addPreds(Path.get(this.info, null, invSteps));
                }
            }
            for (int s = smin + 1; s < this.steps.length; ++s) {
                result.steps = Array.add(result.steps, this.steps[s]);
            }
            return result;
        }
        stp.preds[pmin] = ie;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        Value cv = ctx.value;
        long cs = ctx.size;
        long cp = ctx.pos;
        Value r = this.root != null ? ctx.value(this.root) : cv;
        try {
            if (!(this.cache && this.citer != null && (this.lvalue == r || r instanceof ANode && this.lvalue instanceof ANode && ((ANode)this.lvalue).is((ANode)r)))) {
                this.lvalue = r;
                this.citer = new NodeSeqBuilder().check();
                if (r != null) {
                    Item it;
                    Iter ir = ctx.iter(r);
                    while ((it = ir.next()) != null) {
                        ctx.value = it;
                        this.iter(0, this.citer, ctx);
                    }
                } else {
                    ctx.value = null;
                    this.iter(0, this.citer, ctx);
                }
                this.citer.sort();
            } else {
                this.citer.reset();
            }
            NodeSeqBuilder nodeSeqBuilder = this.citer;
            return nodeSeqBuilder;
        }
        finally {
            ctx.value = cv;
            ctx.size = cs;
            ctx.pos = cp;
        }
    }

    private void iter(int l, NodeSeqBuilder nc, QueryContext ctx) throws QueryException {
        ANode node;
        boolean more;
        NodeIter ni = (NodeIter)ctx.iter(this.steps[l]);
        boolean bl = more = l + 1 != this.steps.length;
        while ((node = ni.next()) != null) {
            if (more) {
                ctx.value = node;
                this.iter(l + 1, nc, ctx);
                continue;
            }
            ctx.checkStop();
            nc.add(node);
        }
    }

    public final AxisPath invertPath(Expr r, AxisStep curr) {
        int s = this.steps.length;
        Expr[] e = new Expr[s--];
        Expr rt = this.step((int)s).preds.length != 0 ? new Filter(this.info, r, this.step((int)s).preds) : r;
        int c = 0;
        while (--s >= 0) {
            e[c++] = AxisStep.get(this.info, this.step((int)(s + 1)).axis.invert(), this.step((int)s).test, this.step((int)s).preds);
        }
        e[c] = AxisStep.get(this.info, this.step((int)(s + 1)).axis.invert(), curr.test, new Expr[0]);
        return new AxisPath(this.info, rt, e);
    }

    @Override
    public final Expr addText(QueryContext ctx) {
        AxisStep s = this.step(this.steps.length - 1);
        if (s.preds.length != 0 || !s.axis.down || s.test.type == NodeType.ATT || s.test.mode != Test.Mode.NAME && s.test.mode != Test.Mode.STD) {
            return this;
        }
        Data data = ctx.data();
        if (data == null || !data.meta.uptodate) {
            return this;
        }
        Stats stats = data.tagindex.stat(data.tagindex.id(s.test.name.local()));
        if (stats != null && stats.isLeaf()) {
            this.steps = Array.add(this.steps, AxisStep.get(this.info, Axis.CHILD, Test.TXT, new Expr[0]));
            ctx.compInfo("adding text() step", this);
        }
        return this;
    }

    public final AxisStep step(int i) {
        return (AxisStep)this.steps[i];
    }

    @Override
    public final Path copy() {
        Expr[] stps = new Expr[this.steps.length];
        for (int s = 0; s < this.steps.length; ++s) {
            stps[s] = AxisStep.get(this.step(s));
        }
        return AxisPath.get(this.info, this.root, stps);
    }

    public ArrayList<PathNode> nodes(QueryContext ctx) {
        Data data;
        Value rt = this.root(ctx);
        Data data2 = data = rt != null && rt.type == NodeType.DOC ? rt.data() : null;
        if (data == null || !data.meta.uptodate) {
            return null;
        }
        ArrayList<PathNode> nodes = data.paths.root();
        for (int s = 0; s < this.steps.length; ++s) {
            AxisStep curr = this.axisStep(s);
            if (curr == null) {
                return null;
            }
            if ((nodes = curr.nodes(nodes, data)) != null) continue;
            return null;
        }
        return nodes;
    }

    @Override
    public final int count(Var v) {
        int c = 0;
        for (Expr s : this.steps) {
            c += s.count(v);
        }
        return c + super.count(v);
    }

    @Override
    public final boolean removable(Var v) {
        for (Expr s : this.steps) {
            if (s.removable(v)) continue;
            return false;
        }
        return super.removable(v);
    }

    @Override
    public final Expr remove(Var v) {
        for (int s = 0; s != this.steps.length; ++s) {
            this.steps[s].remove(v);
        }
        return super.remove(v);
    }

    @Override
    public final boolean iterable() {
        return true;
    }

    @Override
    public final boolean sameAs(Expr cmp) {
        if (!(cmp instanceof AxisPath)) {
            return false;
        }
        AxisPath ap = (AxisPath)cmp;
        if ((this.root == null || ap.root == null) && this.root != ap.root || this.steps.length != ap.steps.length || this.root != null && !this.root.sameAs(ap.root)) {
            return false;
        }
        for (int s = 0; s < this.steps.length; ++s) {
            if (this.steps[s].sameAs(ap.steps[s])) continue;
            return false;
        }
        return true;
    }
}

