/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.path;

import java.util.ArrayList;
import org.basex.data.Data;
import org.basex.data.ExprInfo;
import org.basex.index.name.Names;
import org.basex.index.path.PathNode;
import org.basex.index.stats.Stats;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Preds;
import org.basex.query.iter.AxisIter;
import org.basex.query.iter.NodeIter;
import org.basex.query.iter.NodeSeqBuilder;
import org.basex.query.path.Axis;
import org.basex.query.path.IterPosStep;
import org.basex.query.path.IterStep;
import org.basex.query.path.NameTest;
import org.basex.query.path.Test;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.Array;
import org.basex.util.InputInfo;

public class AxisStep
extends Preds {
    Axis axis;
    public Test test;

    public static AxisStep get(AxisStep s) {
        return AxisStep.get(s.info, s.axis, s.test, s.preds);
    }

    public static AxisStep get(InputInfo ii, Axis a, Test t, Expr ... p) {
        boolean num = false;
        for (Expr pr : p) {
            num |= pr.type().mayBeNumber() || pr.uses(Expr.Use.POS);
        }
        return num ? new AxisStep(ii, a, t, p) : new IterStep(ii, a, t, p);
    }

    AxisStep(InputInfo ii, Axis a, Test t, Expr ... p) {
        super(ii, p);
        this.axis = a;
        this.test = t;
        this.type = SeqType.NOD_ZM;
    }

    @Override
    public final Expr compile(QueryContext ctx) throws QueryException {
        Type ct;
        if (!this.test.compile(ctx)) {
            return Empty.SEQ;
        }
        Data data = ctx.data();
        boolean bl = ctx.leaf = data != null && this.test.mode == Test.Mode.NAME && this.test.type != NodeType.ATT && this.axis.down && data.meta.uptodate && data.nspaces.size() == 0;
        if (ctx.leaf) {
            Stats s = data.tagindex.stat(data.tagindex.id(((NameTest)this.test).ln));
            ctx.leaf = s != null && s.isLeaf();
        }
        Type type = ct = ctx.value != null ? ctx.value.type : null;
        if (ct == NodeType.DOC) {
            ctx.value.type = NodeType.NOD;
        }
        Expr e = super.compile(ctx);
        if (ct == NodeType.DOC) {
            ctx.value.type = ct;
        }
        ctx.leaf = false;
        if (e != this || e instanceof IterStep) {
            return e;
        }
        if (!this.uses(Expr.Use.POS)) {
            return new IterStep(this.info, this.axis, this.test, this.preds);
        }
        if (this instanceof IterPosStep) {
            return this;
        }
        return this.useIterator() ? new IterPosStep(this) : this;
    }

    @Override
    public NodeIter iter(QueryContext ctx) throws QueryException {
        ANode n;
        Value v = this.checkCtx(ctx);
        if (!v.type.isNode()) {
            Err.NODESPATH.thrw(this.info, this, v.type);
        }
        AxisIter ai = this.axis.iter((ANode)v);
        NodeSeqBuilder nc = new NodeSeqBuilder();
        while ((n = ai.next()) != null) {
            if (!this.test.eq(n)) continue;
            nc.add(n.finish());
        }
        for (Expr p : this.preds) {
            ctx.size = nc.size();
            ctx.pos = 1L;
            int c = 0;
            int n2 = 0;
            while ((long)n2 < nc.size()) {
                ctx.value = nc.get(n2);
                Item i = p.test(ctx, this.info);
                if (i != null) {
                    nc.get(n2).score(i.score());
                    nc.item[c++] = nc.get(n2);
                }
                ++ctx.pos;
                ++n2;
            }
            nc.size(c);
        }
        return nc;
    }

    public final boolean simple(Axis ax, boolean name) {
        return this.axis == ax && this.preds.length == 0 && (name ? this.test.mode == Test.Mode.NAME : this.test == Test.NOD);
    }

    final ArrayList<PathNode> nodes(ArrayList<PathNode> nodes, Data data) {
        if (this.preds.length != 0 || data.nspaces.globalNS() == null) {
            return null;
        }
        byte kind = -1;
        int name = 0;
        if (this.test.type != null) {
            kind = ANode.kind(this.test.type);
            if (kind == 5) {
                return null;
            }
            if (this.test.mode == Test.Mode.NAME) {
                Names names = kind == 3 ? data.atnindex : data.tagindex;
                name = names.id(((NameTest)this.test).ln);
            } else if (this.test.mode != null && this.test.mode != Test.Mode.ALL) {
                return null;
            }
        }
        if (this.axis != Axis.ATTR && this.axis != Axis.CHILD && this.axis != Axis.DESC && this.axis != Axis.DESCORSELF && this.axis != Axis.SELF) {
            return null;
        }
        ArrayList<PathNode> tmp = new ArrayList<PathNode>();
        for (PathNode n : nodes) {
            if (!(this.axis != Axis.SELF && this.axis != Axis.DESCORSELF || kind != -1 && (kind != n.kind || name != 0 && name != n.name) || tmp.contains(n))) {
                tmp.add(n);
            }
            if (this.axis == Axis.SELF) continue;
            this.add(n, tmp, name, kind);
        }
        return tmp;
    }

    private void add(PathNode node, ArrayList<PathNode> nodes, int name, int kind) {
        for (PathNode n : node.ch) {
            if (this.axis == Axis.DESC || this.axis == Axis.DESCORSELF) {
                this.add(n, nodes, name, kind);
            }
            if ((kind != -1 || !(n.kind != 3 ^ this.axis == Axis.ATTR)) && (kind != n.kind || name != 0 && name != n.name) || nodes.contains(n)) continue;
            nodes.add(n);
        }
    }

    final AxisStep addPreds(Expr ... prds) {
        for (Expr p : prds) {
            this.preds = Array.add(this.preds, p);
        }
        return AxisStep.get(this.info, this.axis, this.test, this.preds);
    }

    @Override
    public final boolean sameAs(Expr cmp) {
        if (!(cmp instanceof AxisStep)) {
            return false;
        }
        AxisStep st = (AxisStep)cmp;
        if (this.preds.length != st.preds.length || this.axis != st.axis || !this.test.sameAs(st.test)) {
            return false;
        }
        for (int p = 0; p < this.preds.length; ++p) {
            if (this.preds[p].sameAs(st.preds[p])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final void plan(FElem plan) {
        FElem el = this.planElem(QueryText.AXIS, this.axis.name, QueryText.TEST, this.test);
        this.addPlan(plan, el, new ExprInfo[0]);
        super.plan(el);
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.test == Test.NOD) {
            if (this.axis == Axis.PARENT) {
                sb.append("..");
            }
            if (this.axis == Axis.SELF) {
                sb.append('.');
            }
        }
        if (sb.length() == 0) {
            if (this.axis == Axis.ATTR && this.test != Test.NOD) {
                sb.append('@');
            } else if (this.axis != Axis.CHILD) {
                sb.append((Object)this.axis).append("::");
            }
            sb.append(this.test);
        }
        return sb.append(super.toString()).toString();
    }
}

