/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.path;

import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.path.Test;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Token;

public final class NameTest
extends Test {
    public final byte[] ln;

    public NameTest(boolean att) {
        this(null, Test.Mode.ALL, att);
    }

    public NameTest(QNm nm, Test.Mode t, boolean att) {
        this.type = att ? NodeType.ATT : NodeType.ELM;
        this.ln = nm != null ? nm.local() : null;
        this.name = nm;
        this.mode = t;
    }

    @Override
    public boolean compile(QueryContext ctx) {
        Data data = ctx.data();
        if (data == null) {
            return true;
        }
        byte[] ns = data.nspaces.globalNS();
        if (ns == null) {
            return true;
        }
        boolean ok = true;
        if (this.mode == Test.Mode.STD && !this.name.hasPrefix()) {
            byte[] nse = ctx.sc.nsElem != null ? ctx.sc.nsElem : Token.EMPTY;
            boolean bl = ok = this.type == NodeType.ATT || Token.eq(ns, nse);
            if (ok) {
                ctx.compInfo("removing namespace test for \"%\"", this);
                this.mode = Test.Mode.NAME;
            }
        }
        boolean bl = ok && (this.mode != Test.Mode.NAME || (this.type == NodeType.ELM ? data.tagindex : data.atnindex).contains(this.ln)) ? true : (ok = false);
        if (!ok) {
            ctx.compInfo("removing unknown element/attribute %", this.name);
        }
        return ok;
    }

    @Override
    public boolean eq(ANode node) {
        if (node.type != this.type) {
            return false;
        }
        switch (this.mode) {
            case ALL: {
                return true;
            }
            case NAME: {
                return Token.eq(this.ln, Token.local(node.name()));
            }
            case NS: {
                return Token.eq(this.name.uri(), node.qname(this.tmpq).uri());
            }
        }
        return this.type == NodeType.ATT && !this.name.hasPrefix() ? Token.eq(this.ln, node.name()) : this.name.eq(node.qname(this.tmpq));
    }

    public String toString() {
        if (this.mode == Test.Mode.ALL) {
            return "*";
        }
        if (this.mode == Test.Mode.NAME) {
            return "*:" + Token.string(this.name.string());
        }
        String uri = this.name.uri().length == 0 || this.name.hasPrefix() ? "" : '{' + Token.string(this.name.uri()) + '}';
        return uri + (this.mode == Test.Mode.NS ? "*" : Token.string(this.name.string()));
    }
}

