/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.up.DatabaseUpdates;
import org.basex.query.up.primitives.UpdatePrimitive;
import org.basex.util.list.StringList;

public abstract class ContextModifier {
    private final Map<Data, DatabaseUpdates> pendingUpdates = new HashMap<Data, DatabaseUpdates>();

    abstract void add(UpdatePrimitive var1, QueryContext var2) throws QueryException;

    final void add(UpdatePrimitive p) throws QueryException {
        Data data = p.data;
        DatabaseUpdates dbp = this.pendingUpdates.get(data);
        if (dbp == null) {
            dbp = new DatabaseUpdates(data);
            this.pendingUpdates.put(data, dbp);
        }
        dbp.add(p);
    }

    void databases(StringList db) {
        for (DatabaseUpdates du : this.pendingUpdates.values()) {
            db.add(du.data().meta.name);
        }
        db.sort(false, true).unique();
    }

    final void apply() throws QueryException {
        Collection<DatabaseUpdates> updates = this.pendingUpdates.values();
        for (DatabaseUpdates c : updates) {
            c.check();
        }
        int i = 0;
        try {
            for (DatabaseUpdates c : updates) {
                c.startUpdate();
                ++i;
            }
            for (DatabaseUpdates c : updates) {
                c.apply();
            }
        }
        catch (QueryException ex) {
            throw ex;
        }
        finally {
            for (DatabaseUpdates c : updates) {
                if (i-- == 0) break;
                c.finishUpdate();
            }
        }
    }

    final int size() {
        int s = 0;
        for (DatabaseUpdates c : this.pendingUpdates.values()) {
            s += c.size();
        }
        return s;
    }
}

