/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up;

import java.util.ArrayList;
import java.util.Arrays;
import org.basex.data.Data;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.InsertBefore;
import org.basex.query.up.primitives.PrimitiveType;
import org.basex.query.up.primitives.StructuralUpdate;
import org.basex.query.up.primitives.UpdatePrimitive;
import org.basex.util.Util;
import org.basex.util.list.IntList;

final class NodeUpdates {
    UpdatePrimitive[] prim = new UpdatePrimitive[1];
    private boolean del;
    private boolean rep;
    private boolean adjEXT;
    private boolean adjINT;

    NodeUpdates() {
    }

    void add(UpdatePrimitive p) throws QueryException {
        if (this.prim[0] == null) {
            this.prim[0] = p;
            return;
        }
        PrimitiveType pt = p.type;
        for (UpdatePrimitive up : this.prim) {
            if (up.type != pt) continue;
            up.merge(p);
            return;
        }
        this.addToPrimitives(p);
    }

    private void addToPrimitives(UpdatePrimitive p) {
        int l = this.prim.length;
        UpdatePrimitive[] t = new UpdatePrimitive[l + 1];
        System.arraycopy(this.prim, 0, t, 0, l);
        t[l] = p;
        this.prim = t;
    }

    private UpdatePrimitive find(PrimitiveType t) {
        for (UpdatePrimitive p : this.prim) {
            if (p.type != t) continue;
            return p;
        }
        return null;
    }

    private void prepareExecution() {
        for (UpdatePrimitive p : this.prim) {
            PrimitiveType t = p.type;
            this.del |= t == PrimitiveType.DELETENODE;
            this.rep |= t == PrimitiveType.REPLACENODE;
        }
        if (this.prim.length > 1 && (this.rep || this.del)) {
            PrimitiveType dominantOp = this.rep ? PrimitiveType.REPLACENODE : PrimitiveType.DELETENODE;
            ArrayList<UpdatePrimitive> up = new ArrayList<UpdatePrimitive>();
            for (UpdatePrimitive p : this.prim) {
                PrimitiveType t = p.type;
                if (t != PrimitiveType.INSERTBEFORE && t != PrimitiveType.INSERTAFTER && t != dominantOp) continue;
                up.add(p);
            }
            this.prim = up.toArray(new UpdatePrimitive[up.size()]);
        }
        for (UpdatePrimitive p : this.prim) {
            PrimitiveType t = p.type;
            this.del |= t == PrimitiveType.DELETENODE;
            this.rep |= t == PrimitiveType.REPLACENODE;
            this.adjEXT |= this.del || this.rep || t == PrimitiveType.INSERTBEFORE || t == PrimitiveType.INSERTAFTER;
            this.adjINT |= t == PrimitiveType.INSERTINTO || t == PrimitiveType.INSERTINTOFIRST || t == PrimitiveType.INSERTINTOLAST;
        }
        if (this.prim.length > 1) {
            Arrays.sort(this.prim);
        }
    }

    boolean updatesDestroyIdentity(int pre) {
        return (this.del || this.rep) && this.prim[0].pre == pre || this.destroyedNodeIdentities().contains(pre);
    }

    IntList destroyedNodeIdentities() {
        IntList d = new IntList();
        block4: for (UpdatePrimitive p : this.prim) {
            PrimitiveType t = p.type;
            switch (t) {
                case DELETENODE: 
                case REPLACENODE: {
                    d.add(p.pre);
                    continue block4;
                }
                case REPLACEELEMCONT: {
                    Data data = p.data;
                    int pre = p.pre;
                    int kind = data.kind(pre);
                    int l = pre + data.size(pre, kind);
                    for (int ipre = pre + data.attSize(pre, kind); ipre < l; ipre += data.size(ipre, data.kind(ipre))) {
                        d.add(ipre);
                    }
                    continue block4;
                }
            }
        }
        return d;
    }

    int makePrimitivesEffective() throws QueryException {
        this.prepareExecution();
        int sd = 0;
        for (UpdatePrimitive p : this.prim) {
            p.apply();
            if (!(p instanceof StructuralUpdate)) continue;
            sd += ((StructuralUpdate)p).preShifts();
        }
        if (this.adjINT) {
            return sd - this.resolveInternalTextNodeAdjacency();
        }
        return sd;
    }

    private int resolveInternalTextNodeAdjacency() {
        int merged = 0;
        InsertBefore ib = (InsertBefore)this.find(PrimitiveType.INSERTBEFORE);
        int c = ib == null ? 0 : ib.preShifts();
        for (int i = this.prim.length - 1; i >= 0; --i) {
            if (!(this.prim[i] instanceof StructuralUpdate)) continue;
            StructuralUpdate p = (StructuralUpdate)this.prim[i];
            if (p.type == PrimitiveType.INSERTAFTER || p.type == PrimitiveType.INSERTBEFORE || p.type == PrimitiveType.REPLACENODE || p.type == PrimitiveType.DELETENODE) continue;
            if (p.adjacentTexts(c)) {
                ++merged;
                --c;
            }
            c += p.preShifts();
        }
        return merged;
    }

    void resolveExternalTextNodeAdjacency(int preShifts) {
        if (!this.adjEXT) {
            return;
        }
        int c = preShifts;
        for (int i = this.prim.length - 1; i >= 0; --i) {
            if (!(this.prim[i] instanceof StructuralUpdate)) continue;
            StructuralUpdate p = (StructuralUpdate)this.prim[i];
            if ((p.type == PrimitiveType.INSERTAFTER || p.type == PrimitiveType.INSERTBEFORE || p.type == PrimitiveType.DELETENODE || p.type == PrimitiveType.REPLACENODE) && p.adjacentTexts(c)) {
                --c;
            }
            c += p.preShifts();
        }
    }

    public String toString() {
        return Util.name(this);
    }
}

