/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.basex.build.DirParser;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.core.Context;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.InsertBase;
import org.basex.query.up.primitives.PrimitiveType;
import org.basex.query.up.primitives.UpdatePrimitive;
import org.basex.query.util.DataBuilder;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.TokenList;

public final class DBAdd
extends InsertBase {
    private ArrayList<Item> docs = new ArrayList();
    private TokenList paths = new TokenList();
    private final Context ctx;

    public DBAdd(Data d, InputInfo i, Item it, String p, Context c) {
        super(PrimitiveType.INSERTAFTER, -1, d, i, null);
        this.docs.add(it);
        this.paths.add(Token.token(p));
        this.ctx = c;
    }

    @Override
    public boolean adjacentTexts(int c) {
        return false;
    }

    @Override
    public void merge(UpdatePrimitive u) {
        DBAdd a = (DBAdd)u;
        Iterator<Item> d = a.docs.iterator();
        Iterator<byte[]> p = a.paths.iterator();
        while (d.hasNext()) {
            this.docs.add(d.next());
            this.paths.add(p.next());
        }
    }

    @Override
    public void apply() {
        super.apply();
        this.data.insert(this.data.meta.size, -1, this.md);
    }

    @Override
    public void prepare() throws QueryException {
        this.md = new MemData(this.data);
        for (int i = 0; i < this.docs.size(); ++i) {
            this.md.insert(this.md.meta.size, -1, this.docData(this.docs.get(i), this.paths.get(i)));
            this.docs.set(i, null);
            this.paths.set(i, null);
            ++this.size;
        }
        this.docs = null;
        this.paths = null;
    }

    private Data docData(Item doc, byte[] pth) throws QueryException {
        MemData mdata;
        String name = Token.string(pth);
        if (name.endsWith(".")) {
            Err.RESINV.thrw(this.info, new Object[]{pth});
        }
        IO io = null;
        Type dt = doc.type;
        if (dt.isString()) {
            io = IO.get(Token.string(doc.string(this.info)));
            if (!io.exists()) {
                Err.WHICHRES.thrw(this.info, new Object[]{pth});
            }
            if (!name.endsWith("/") && (io.isDir() || io.isArchive())) {
                name = name + "/";
            }
        }
        String target = "";
        int s = name.lastIndexOf(47);
        if (s != -1) {
            target = name.substring(0, s);
            name = name.substring(s + 1);
        }
        if (dt.isString()) {
            if (!name.isEmpty()) {
                io.name(name);
            } else if (!(io instanceof IOContent)) {
                name = io.name();
            }
        }
        if (name.isEmpty()) {
            Err.RESINV.thrw(this.info, new Object[]{pth});
        }
        if (dt.isNode()) {
            ANode nd = (ANode)doc;
            if (nd.type != NodeType.DOC) {
                Err.UPDOCTYPE.thrw(this.info, nd);
            }
            mdata = new MemData(this.data);
            new DataBuilder(mdata).build(nd);
            mdata.update(0, 0, pth);
        } else if (dt.isString()) {
            Parser p = new DirParser(io, this.ctx.prop, this.data.meta.path).target(target);
            MemBuilder b = new MemBuilder(this.data.meta.name, p);
            try {
                mdata = b.build();
            }
            catch (IOException ex) {
                throw Err.IOERR.thrw(this.info, ex);
            }
        } else {
            throw Err.STRNODTYPE.thrw(this.info, this, doc.type);
        }
        return mdata;
    }

    @Override
    public String toString() {
        return Util.name(this) + '[' + this.docs.get(0) + ']';
    }
}

