/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import org.basex.core.cmd.Delete;
import org.basex.data.Data;
import org.basex.query.up.primitives.PrimitiveType;
import org.basex.query.up.primitives.UpdatePrimitive;
import org.basex.util.InputInfo;
import org.basex.util.list.StringList;

public final class DBDelete
extends UpdatePrimitive {
    private final StringList paths = new StringList(1);
    private int size;

    public DBDelete(Data d, String p, InputInfo ii) {
        super(PrimitiveType.DBDELETE, -1, d, ii);
        this.paths.add(p);
        this.size = d.resources.binaries(p).size();
    }

    @Override
    public void merge(UpdatePrimitive p) {
        for (String path : ((DBDelete)p).paths) {
            this.paths.add(path);
        }
        this.size += p.size();
    }

    @Override
    public void apply() {
        for (String path : this.paths) {
            Delete.delete(this.data, path);
        }
    }

    @Override
    public int size() {
        return this.size;
    }
}

