/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.io.IOFile;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.PrimitiveType;
import org.basex.query.up.primitives.UpdatePrimitive;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjMap;

public final class DBStore
extends UpdatePrimitive {
    private final TokenObjMap<Item> map = new TokenObjMap();

    public DBStore(Data d, String path, Item it, InputInfo ii) {
        super(PrimitiveType.DBSTORE, -1, d, ii);
        this.map.add(Token.token(path), it);
    }

    @Override
    public void merge(UpdatePrimitive p) {
        DBStore put = (DBStore)p;
        for (byte[] path : put.map) {
            this.map.add(path, put.map.get(path));
        }
    }

    @Override
    public void apply() throws QueryException {
        for (byte[] path : this.map) {
            try {
                IOFile file = this.data.meta.binary(Token.string(path));
                if (file == null) {
                    Err.UPDBPUTERR.thrw(this.info, new Object[]{path});
                }
                new IOFile(file.dir()).md();
                file.write(this.map.get(path).input(this.info));
            }
            catch (IOException ex) {
                Util.debug(ex);
                Err.UPDBPUTERR.thrw(this.info, new Object[]{path});
            }
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }
}

