/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerProp;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.PrimitiveType;
import org.basex.query.up.primitives.UpdatePrimitive;
import org.basex.query.util.Err;
import org.basex.query.value.node.DBNode;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class Put
extends UpdatePrimitive {
    private final StringList paths = new StringList(1);

    public Put(InputInfo i, int p, Data d, String u) {
        super(PrimitiveType.PUT, p, d, i);
        this.paths.add(u);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply() throws QueryException {
        for (String u : this.paths) {
            DBNode node = new DBNode(this.data, this.pre);
            try {
                PrintOutput po = new PrintOutput(u);
                try {
                    SerializerProp pr = new SerializerProp();
                    pr.set(SerializerProp.S_INDENT, node.data.meta.chop ? "yes" : "no");
                    Serializer ser = Serializer.get(po, pr);
                    ser.serialize(node);
                    ser.close();
                }
                finally {
                    po.close();
                }
            }
            catch (IOException ex) {
                Err.UPPUTERR.thrw(this.info, u);
            }
        }
    }

    @Override
    public void merge(UpdatePrimitive p) throws QueryException {
        for (String u : ((Put)p).paths) {
            this.paths.add(u);
        }
    }

    @Override
    public int size() {
        return this.paths.size();
    }

    public String toString() {
        return Util.name(this) + '[' + this.targetNode() + ", " + this.paths.get(0) + ']';
    }
}

