/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import org.basex.query.value.Value;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.NodeType;
import org.basex.util.Array;

public final class ANodeList {
    private ANode[] list;
    private int size;

    public ANodeList() {
        this(1);
    }

    public ANodeList(int c) {
        this.list = new ANode[c];
    }

    public ANodeList(ANode ... n) {
        this.list = n;
        this.size = n.length;
    }

    public ANodeList add(ANode e) {
        if (this.size == this.list.length) {
            this.resize(Array.newSize(this.size));
        }
        this.list[this.size++] = e;
        return this;
    }

    public void set(int i, ANode e) {
        if (i >= this.list.length) {
            this.resize(Array.newSize(i + 1));
        }
        this.list[i] = e;
        this.size = Math.max(this.size, i + 1);
    }

    public ANode get(int p) {
        return this.list[p];
    }

    public int size() {
        return this.size;
    }

    public Value value() {
        return Seq.get(this.list, this.size, NodeType.NOD);
    }

    private void resize(int s) {
        ANode[] tmp = new ANode[s];
        System.arraycopy(this.list, 0, tmp, 0, this.size);
        this.list = tmp;
    }
}

