/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import org.basex.io.serial.SerializerException;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.ParseExpr;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public enum Err {
    BASX_GENERIC(ErrType.BASX, 0, "%"),
    BASX_PERM(ErrType.BASX, 1, "% permission required."),
    BASX_OPTIONS(ErrType.BASX, 2, "Unknown database option '%'."),
    BASX_RESTXQ(ErrType.BASX, 3, "%"),
    BXCL_CONN(ErrType.BXCL, 1, "Connection failed: %"),
    BXCL_NOTAVL(ErrType.BXCL, 2, "Session is not available or has already been closed: %"),
    BXCL_COMM(ErrType.BXCL, 3, "An error occurred: %"),
    BXCL_COMMAND(ErrType.BXCL, 4, "Command could not be executed: %"),
    BXCL_QUERY(ErrType.BXCL, 5, "Query could not be executed: %"),
    BXCL_ITEM(ErrType.BXCL, 6, "Value to be bound is no single item: %"),
    BXCO_STRING(ErrType.BXCO, 1, "String conversion: %."),
    BXCO_BASE64(ErrType.BXCO, 1, "String cannot be converted to the specified encoding."),
    BXCO_ENCODING(ErrType.BXCO, 2, "Encoding '%' is not supported."),
    BXDB_NODB(ErrType.BXDB, 1, "%: database node expected."),
    BXDB_OPEN(ErrType.BXDB, 2, "%"),
    BXDB_MEM(ErrType.BXDB, 3, "Operation requires database '%' to be persistent."),
    BXDB_INDEX(ErrType.BXDB, 4, "Database '%' has no % index."),
    BXDB_DBRETURN(ErrType.BXDB, 5, "Query must yield database nodes."),
    BXDB_SINGLE(ErrType.BXDB, 6, "Database path '%' must point to a single document."),
    BXDB_OPENED(ErrType.BXDB, 7, "Database '%' is opened by another process."),
    BXDB_EMPTY(ErrType.BXDB, 8, "%: Database paths must not be empty."),
    BXDB_RANGE(ErrType.BXDB, 9, "%: value '%' is out of range."),
    BXDB_EVENT(ErrType.BXDB, 10, "Event '%' is unknown."),
    BXFT_MATCH(ErrType.BXFT, 1, "Either wildcards or fuzzy search supported."),
    BXJS_PARSE(ErrType.BXJS, 1, "JSON parser (%:%): %."),
    BXJS_PARSEML(ErrType.BXJS, 1, "JsonML parser: %."),
    BXJS_SER(ErrType.BXJS, 1, "JSON serialization: %."),
    BXPR_ENC(ErrType.BXPR, 9999, "Encoding not supported: '%'."),
    BXRE_WHICH(ErrType.BXRE, 1, "Package '%' does not exist."),
    BXRE_URI(ErrType.BXRE, 2, "Namespace URI is invalid: '%'."),
    BXRE_NOTINST(ErrType.BXRE, 3, "Required package '%' is not installed."),
    BXRE_DESC(ErrType.BXRE, 4, "Package descriptor: %."),
    BXRE_INST(ErrType.BXRE, 5, "Module % is already installed within another package."),
    BXRE_PARSE(ErrType.BXRE, 6, "Package '%' could not be parsed: %."),
    BXRE_PARSENF(ErrType.BXRE, 6, "Package '%' could not be parsed: '%' not found."),
    BXRE_DELETE(ErrType.BXRE, 7, "File '%' could not be deleted."),
    BXRE_DEP(ErrType.BXRE, 8, "Package '%' depends on package '%'."),
    BXRE_VERSION(ErrType.BXRE, 9, "Package version is not supported."),
    BXRE_JARDESC(ErrType.BXRE, 10, "JAR descriptor: %."),
    BXRE_JARFAIL(ErrType.BXRE, 11, "Reading JAR descriptor failed: %."),
    BXSQ_ERROR(ErrType.BXSQ, 1, "An SQL exception occurred: '%'"),
    BXSQ_CONN(ErrType.BXSQ, 2, "No opened connection with id %"),
    BXSQ_STATE(ErrType.BXSQ, 2, "No prepared statement with id %"),
    BXSQ_PARAMS(ErrType.BXSQ, 3, "Number of parameters differs from number of placeholders"),
    BXSQ_TYPE(ErrType.BXSQ, 4, "No parameter type specified."),
    BXSQ_ATTR(ErrType.BXSQ, 5, "Not expected attribute: %"),
    BXSQ_FORMAT(ErrType.BXSQ, 6, "Illegal % format"),
    BXSQ_DRIVER(ErrType.BXSQ, 7, "Could not initialize specified driver: '%'"),
    BXVA_FAIL(ErrType.BXVA, 1, "Validation failed: %"),
    BXXQ_UPDATING(ErrType.BXXQ, 1, "No updating expression allowed."),
    ARCH_DIFF(ErrType.ARCH, 1, "Number of entries (%) and contents (%) differs."),
    ARCH_UNKNOWN(ErrType.ARCH, 2, "Packing format not supported."),
    ARCH_SUPP(ErrType.ARCH, 2, "% not supported: '%'."),
    ARCH_EMPTY(ErrType.ARCH, 3, "Name of ZIP entry must not be empty."),
    ARCH_LEVEL(ErrType.ARCH, 3, "Invalid compression level: '%'."),
    ARCH_DATETIME(ErrType.ARCH, 3, "xs:dateTime value is invalid : '%'."),
    ARCH_ENCODING(ErrType.ARCH, 4, "Encoding is not supported: '%'."),
    ARCH_ENCODE(ErrType.ARCH, 4, "String conversion: %."),
    ARCH_MODIFY(ErrType.ARCH, 5, "Entries of % archive cannot be modified."),
    ARCH_ONE(ErrType.ARCH, 6, "% archives are limited to a single entry."),
    ARCH_FAIL(ErrType.ARCH, 9999, "Operation failed: %."),
    CX_CANINV(ErrType.CX, 1, "Canonicalization algorithm is not supported."),
    CX_DIGINV(ErrType.CX, 2, "Digest algorithm is not supported."),
    CX_SIGINV(ErrType.CX, 3, "Signature algorithm is not supported."),
    CX_XPINV(ErrType.CX, 4, "XPath expression is invalid."),
    CX_INVNM(ErrType.CX, 5, "Invalid name for $digital-certificate root."),
    CX_KSNULL(ErrType.CX, 7, "Key store is null: %"),
    CX_NOKEY(ErrType.CX, 12, "Cannot find key for alias in given keystore."),
    CX_INVHASH(ErrType.CX, 13, "Hashing algorithm is not supported."),
    CX_ENC(ErrType.CX, 14, "The encoding method is not supported."),
    CX_NOSIG(ErrType.CX, 15, "Cannot find signature element."),
    CX_NOPAD(ErrType.CX, 16, "No such padding."),
    CX_BADPAD(ErrType.CX, 17, "Incorrect padding."),
    CX_ENCTYP(ErrType.CX, 18, "Encryption type is not supported."),
    CX_KEYINV(ErrType.CX, 19, "Secret key is invalid."),
    CX_ILLBLO(ErrType.CX, 20, "Illegal block size."),
    CX_INVALGO(ErrType.CX, 21, "Algorithm is not supported."),
    CX_ALINV(ErrType.CX, 23, "Invalid certificate alias %."),
    CX_ALGEXC(ErrType.CX, 24, "Invalid algorithm."),
    CX_IOEXC(ErrType.CX, 25, "IO Exception."),
    CX_KSEXC(ErrType.CX, 26, "Keystore exception."),
    CX_SIGEXC(ErrType.CX, 27, "Signature exception."),
    CX_SIGTYPINV(ErrType.CX, 28, "Signature type is not supported."),
    FILE_WHICH(ErrType.FILE, 1, "Path '%' does not exist."),
    FILE_EXISTS(ErrType.FILE, 2, "File '%' already exists."),
    FILE_NODIR(ErrType.FILE, 3, "Path '%' is no directory."),
    FILE_DIR(ErrType.FILE, 4, "Path '%' is a directory."),
    FILE_NEDIR(ErrType.FILE, 4, "Path '%' is a non-empty directory."),
    FILE_ENCODING(ErrType.FILE, 5, "Encoding '%' is not supported."),
    FILE_IO(ErrType.FILE, 9999, "%"),
    FILE_CREATE(ErrType.FILE, 9999, "Directory '%' cannot be created."),
    FILE_DEL(ErrType.FILE, 9999, "Path '%' cannot be deleted."),
    FILE_MOVE(ErrType.FILE, 9999, "Moving '%' to '%' failed."),
    FILE_LIST(ErrType.FILE, 9999, "Files of '%' cannot be accessed."),
    FILE_PATH(ErrType.FILE, 9999, "Invalid file path: '%'."),
    HASH_ALG(ErrType.HASH, 1, "Algorithm not supported: '%'."),
    HC_ERROR(ErrType.HC, 1, "An HTTP error occurred: %."),
    HC_ATTR(ErrType.HC, 3, "No attribute beside 'src' and 'media-type' allowed."),
    HC_REQ(ErrType.HC, 4, "Invalid request element: %."),
    HC_URL(ErrType.HC, 5, "No URL specified."),
    HC_PARAMS(ErrType.HC, 6, "Specify request element or HTTP URI."),
    ZIP_NOTFOUND(ErrType.ZIP, 1, "Path '%' is not found."),
    ZIP_INVALID(ErrType.ZIP, 2, "% element: % attribute expected."),
    ZIP_UNKNOWN(ErrType.ZIP, 2, "ZIP definition: unknown element %."),
    ZIP_FAIL(ErrType.ZIP, 3, "Operation failed: %."),
    DIVZERO(ErrType.FOAR, 1, "'%' was divided by zero."),
    DIVFLOW(ErrType.FOAR, 2, "Invalid division result: % / %."),
    RANGE(ErrType.FOAR, 2, "Value out of range: %."),
    INVALUE(ErrType.FOCA, 2, "Invalid value for %: %."),
    INTRANGE(ErrType.FOCA, 3, "Integer value out of range: %."),
    DATECALC(ErrType.FOCA, 5, "Invalid % calculation: %."),
    INVCODE(ErrType.FOCH, 1, "Invalid codepoint '%'."),
    IMPLCOL(ErrType.FOCH, 2, "Unknown collation %."),
    NORMUNI(ErrType.FOCH, 3, "Unsupported normalization form (%)."),
    IDDOC(ErrType.FODC, 1, "Root must be a document node."),
    NODEERR(ErrType.FODC, 2, "% could not be created (%)."),
    NODEFCOLL(ErrType.FODC, 2, "No default collection available."),
    IOERR(ErrType.FODC, 2, "%"),
    WHICHRES(ErrType.FODC, 2, "Resource '%' does not exist."),
    INVCOLL(ErrType.FODC, 4, "Invalid collection URI '%'."),
    INVDOC(ErrType.FODC, 5, "Invalid document URI '%'."),
    SAXERR(ErrType.FODC, 6, "SAX: %."),
    BASEINV(ErrType.FODC, 7, "Base URI % is invalid."),
    RESINV(ErrType.FODC, 7, "Resource path '%' is invalid."),
    INVDB(ErrType.FODC, 7, "Invalid database name: '%'."),
    FORMNUM(ErrType.FODF, 1280, "Unknown decimal format: %."),
    PICNUM(ErrType.FODF, 1310, "Invalid picture string: '%'."),
    DATEZERO(ErrType.FODT, 2, "Invalid % calculation: infinity/zero."),
    INVALZONE(ErrType.FODT, 3, "Invalid timezone: %."),
    FUNERR1(ErrType.FOER, 0, "Halted on error()."),
    NSDECL(ErrType.FONS, 4, "No namespace declared for prefix '%'."),
    INVALIDZONE(ErrType.FORG, 1, "Invalid timezone: %."),
    FUNCAST(ErrType.FORG, 1, "Invalid % cast: %."),
    DATERANGE(ErrType.FORG, 1, "%('%') out of range."),
    DATEFORMAT(ErrType.FORG, 1, "Wrong % format: '%' (try: '%')."),
    URIINV(ErrType.FORG, 2, "Invalid URI: %."),
    URIABS(ErrType.FORG, 2, "Base URI % is not absolute."),
    EXPECTZ0(ErrType.FORG, 3, "Zero or one value expected."),
    EXPECTOM(ErrType.FORG, 4, "One or more values expected."),
    EXPECTO(ErrType.FORG, 5, "Exactly one value expected."),
    FUNCMP(ErrType.FORG, 6, "%: % expected, % found."),
    CONDTYPE(ErrType.FORG, 6, "% not allowed as condition type."),
    SUMTYPE(ErrType.FORG, 6, "%: invalid argument type '%'."),
    FUNNUM(ErrType.FORG, 6, "%: number expected, % found."),
    FUNDUR(ErrType.FORG, 6, "%: duration expected, % found."),
    TYPECMP(ErrType.FORG, 6, "% is not comparable."),
    JAVAFUN(ErrType.FORG, 6, "Invalid call of Java function: %(%)."),
    JAVAMOD(ErrType.FORG, 6, "Invalid arguments: % expected, % found."),
    INVBASE(ErrType.FORG, 6, "Unsupported base: %."),
    INVDIG(ErrType.FORG, 6, "Invalid digit for base %: %."),
    JAVAERR(ErrType.FORG, 6, "Java function call failed: %."),
    ERRFORM(ErrType.FORG, 6, "%: %."),
    BINARYTYPE(ErrType.FORG, 6, "Binary item expected, % found"),
    STRNODTYPE(ErrType.FORG, 6, "%: string or node expected, % found."),
    ELMMAPTYPE(ErrType.FORG, 6, "element(%) or map expected, % found"),
    ELMSTRTYPE(ErrType.FORG, 6, "element(%) or string expected, % found"),
    STRB64TYPE(ErrType.FORG, 6, "String or Base64 expected, % found"),
    ELMOPTION(ErrType.FORG, 6, "Unknown option: %."),
    FUNZONE(ErrType.FORG, 8, "% and % have different timezones."),
    REGMOD(ErrType.FORX, 1, "Invalid regular modifier: '%'."),
    REGROUP(ErrType.FORX, 3, "Pattern matches empty string."),
    FUNREGREP(ErrType.FORX, 4, "Invalid replacement expression."),
    REGERR(ErrType.FORX, 4, "Regular expression: '%'."),
    FIVALUE(ErrType.FOTY, 12, "Item has no typed value: %."),
    FIATOM(ErrType.FOTY, 13, "Function items cannot be atomized: %."),
    FIEQ(ErrType.FOTY, 13, "Function items have no defined equality: %."),
    FISTR(ErrType.FOTY, 14, "Function items have no string representation: %."),
    FICMP(ErrType.FOTY, 15, "Function items cannot be compared: %."),
    UPFOTYPE(ErrType.FOUP, 1, "Document or element expected, % found."),
    UPDOCTYPE(ErrType.FOUP, 1, "Document expected, % found."),
    UPFOURI(ErrType.FOUP, 2, "No valid URI: \"%\"."),
    UPPUTERR(ErrType.FOUP, 2, "\"%\" could not be written."),
    UPDBPUTERR(ErrType.FOUP, 2, "Resource \"%\" could not be written."),
    UPDBDELERR(ErrType.FOUP, 2, "Resource \"%\" could not be deleted."),
    UPDBRENAMEERR(ErrType.FOUP, 2, "Resource \"%\" could not be renamed."),
    UPDBOPTERR(ErrType.FOUP, 2, "Resource \"%\" could not be optimized."),
    FTWEIGHT(ErrType.FTDY, 16, "Weight value out of range: %."),
    FTMILD(ErrType.FTDY, 17, "Invalid 'mild not' selection."),
    FTREG(ErrType.FTDY, 20, "Invalid wildcard syntax: '%'."),
    FTIGNORE(ErrType.FTST, 7, "Ignore option not supported."),
    NOSTOPFILE(ErrType.FTST, 8, "Stop word file not found: '%'."),
    FTNOSTEM(ErrType.FTST, 9, "No stemmer available for language '%'."),
    FTNOTOK(ErrType.FTST, 9, "No tokenizer available for language '%'."),
    NOTHES(ErrType.FTST, 18, "Thesaurus not found: '%'."),
    FTDUP(ErrType.FTST, 19, "Match option '%' was declared twice."),
    SERENCODING(ErrType.SESU, 7, "Encoding not supported: '%'."),
    SERSTAND(ErrType.SEPM, 9, "Invalid combination of 'omit-xml-declaration'."),
    SERUNDECL(ErrType.SEPM, 10, "XML 1.0: undeclaring prefixes not allowed."),
    SERILL(ErrType.SERE, 14, "Illegal HTML character found: #x%."),
    SERPI(ErrType.SERE, 15, "Processing construction contains '>'."),
    SERMAP(ErrType.SEPM, 16, "Character map '%' is not defined."),
    SERANY(ErrType.SEPM, 16, "%."),
    VAREMPTY(ErrType.XPDY, 2, "No value assigned to %."),
    XPNOCTX(ErrType.XPDY, 2, "No context item defined to evaluate '%'."),
    CTXNODE(ErrType.XPDY, 50, "Root of the context item must be a document node."),
    NOTREAT(ErrType.XPDY, 50, "%: % cannot be treated as %."),
    NOTREATS(ErrType.XPDY, 50, "%: % expected, sequence found."),
    STBASEURI(ErrType.XPST, 1, "Static Base URI is undefined."),
    QUERYEMPTY(ErrType.XPST, 3, "Empty query."),
    QUERYINV(ErrType.XPST, 3, "Query contains an illegal character (#%)."),
    NOQUOTE(ErrType.XPST, 3, "Expecting quote%."),
    NOVALIDATE(ErrType.XPST, 3, "Invalid validation expression."),
    NUMBERWS(ErrType.XPST, 3, "Expecting separator after number."),
    NUMBERINC(ErrType.XPST, 3, "Incomplete double value: '%'."),
    NUMBERITR(ErrType.XPST, 3, "Unexpected decimal point."),
    QUERYEND(ErrType.XPST, 3, "Unexpected end of query: '%'."),
    MODEXPR(ErrType.XPST, 3, "No expression allowed in a library module."),
    MAINMOD(ErrType.XPST, 3, "Library modules cannot be evaluated."),
    CMPEXPR(ErrType.XPST, 3, "Comparison is incomplete."),
    NOTAG(ErrType.XPST, 3, "Expecting tag name."),
    TAGNAME(ErrType.XPST, 3, "Expecting tag name, '<%' found."),
    NOATTNAME(ErrType.XPST, 3, "Expecting attribute name."),
    NOLOCSTEP(ErrType.XPST, 3, "Incomplete location step."),
    NOEXPR(ErrType.XPST, 3, "Expecting expression."),
    WRONGCHAR(ErrType.XPST, 3, "Expecting '%'%."),
    INVENTITY(ErrType.XPST, 3, "Invalid entity '%'."),
    INCOMPLETE(ErrType.XPST, 3, "Incomplete expression."),
    EVALUNARY(ErrType.XPST, 3, "Unary operator expects a numeric value."),
    PATHMISS(ErrType.XPST, 3, "Expecting location path%."),
    DECLINCOMPLETE(ErrType.XPST, 3, "Expecting 'function', 'variable', ..."),
    FUNCNAME(ErrType.XPST, 3, "Expecting function name."),
    RESERVED(ErrType.XPST, 3, "% is a reserved function name."),
    PREDMISSING(ErrType.XPST, 3, "Expecting expression before predicate."),
    NOVARNAME(ErrType.XPST, 3, "Expecting variable name."),
    NOVARDECL(ErrType.XPST, 3, "Expecting variable declaration."),
    TAGWRONG(ErrType.XPST, 3, "Start and end tag are different: <%>...</%>."),
    PIWRONG(ErrType.XPST, 3, "Expecting name of processing-instruction."),
    NSWRONG(ErrType.XPST, 3, "Expecting namespace prefix."),
    NOENCLEXPR(ErrType.XPST, 3, "Expecting valid expression after '{'."),
    NODOCCONS(ErrType.XPST, 3, "Expecting expression in document constructor."),
    NOTXTCONS(ErrType.XPST, 3, "Expecting expression in text constructor."),
    NOCOMCONS(ErrType.XPST, 3, "Expecting expression in comment constructor."),
    NOFUNBODY(ErrType.XPST, 3, "Expecting function body."),
    FUNCMISS(ErrType.XPST, 3, "Expecting closing bracket for '%(...'."),
    MAPTAAT(ErrType.XPST, 3, "Expecting atomic key type for map(...), found '%'."),
    TYPEINVALID(ErrType.XPST, 3, "Expecting type declaration."),
    NODECLFORM(ErrType.XPST, 3, "Unknown decimal-format property: '%'."),
    NOTYPESWITCH(ErrType.XPST, 3, "Incomplete typeswitch expression."),
    NOSWITCH(ErrType.XPST, 3, "Incomplete switch expression."),
    TYPEPAR(ErrType.XPST, 3, "Expecting '(' after 'switch' or 'typeswitch'."),
    PRAGMAINV(ErrType.XPST, 3, "Invalid pragma expression."),
    CALCEXPR(ErrType.XPST, 3, "Calculation is incomplete."),
    INVMAPKEY(ErrType.XPST, 3, "Invalid key, simple expression expected."),
    INVMAPVAL(ErrType.XPST, 3, "Invalid value, simple expression expected."),
    NORETURN(ErrType.XPST, 3, "Expecting return value."),
    NOWHERE(ErrType.XPST, 3, "Expecting valid expression after 'where'."),
    ORDERBY(ErrType.XPST, 3, "Expecting valid expression after 'order by'."),
    GRPBY(ErrType.XPST, 3, "Expecting valid expression after 'group by'."),
    FLWORWHERE(ErrType.XPST, 3, "Expecting 'where', 'order' or 'return' expression."),
    FLWORORD(ErrType.XPST, 3, "Expecting 'order' or 'return' expression."),
    FLWORRET(ErrType.XPST, 3, "Expecting 'return' expression."),
    NOSOME(ErrType.XPST, 3, "Incomplete quantifier expression."),
    IFPAR(ErrType.XPST, 3, "Expecting '(' after 'if' expression."),
    NOIF(ErrType.XPST, 3, "Incomplete 'if' expression."),
    NOFOR(ErrType.XPST, 3, "Incomplete 'for' expression."),
    NOLET(ErrType.XPST, 3, "Incomplete 'let' expression."),
    NOCLOSING(ErrType.XPST, 3, "Expecting closing tag </%>."),
    COMCLOSE(ErrType.XPST, 3, "Unclosed XQuery comment (: ..."),
    EXPREMPTY(ErrType.XPST, 3, "Unknown function or expression."),
    NOTYPE(ErrType.XPST, 3, "Unknown type '%'."),
    PIXML(ErrType.XPST, 3, "Processing instruction has illegal name: '%'."),
    QNAMEINV(ErrType.XPST, 3, "Expecting QName, '%' found."),
    PROLOGORDER(ErrType.XPST, 3, "Default declarations must be declared first."),
    FTRANGE(ErrType.XPST, 3, "Expecting full-text range."),
    FTSTOP(ErrType.XPST, 3, "Stop words expected."),
    FTMATCH(ErrType.XPST, 3, "Unknown match option '%...'."),
    INVALPI(ErrType.XPST, 3, "Processing instruction has invalid name."),
    INTEXP(ErrType.XPST, 3, "Integer expected."),
    VARFUNC(ErrType.XPST, 3, "Variable or function declaration expected."),
    NOANN(ErrType.XPST, 3, "No annotation allowed here."),
    NOCATCH(ErrType.XPST, 3, "Expecting catch clause."),
    ANNVALUE(ErrType.XPST, 3, "Literal expected after annotation."),
    UPDATINGVAR(ErrType.XPST, 3, "Variable cannot be updating."),
    COMPSELF(ErrType.XPST, 5, "Warning: '%' will never yield results."),
    ATTDESC(ErrType.XPST, 5, "Warning: '%' cannot have descendants."),
    DOCAXES(ErrType.XPST, 5, "Warning: '%' cannot have % nodes."),
    VARUNDEF(ErrType.XPST, 8, "Undefined variable %."),
    TYPEUNDEF(ErrType.XPST, 8, "Undefined type '%'."),
    SCHEMAINV(ErrType.XPST, 8, "Undefined schema name '%'."),
    XPARGS(ErrType.XPST, 17, "%: wrong number of arguments."),
    FUNSIMILAR(ErrType.XPST, 17, "Unknown function '%'; similar: '%'."),
    FUNCTYPE(ErrType.XPST, 17, "%(...): wrong number of arguments."),
    FEATURE30(ErrType.XPST, 17, "Feature not available in XQuery 1.0."),
    FUNCUNKNOWN(ErrType.XPST, 17, "Unknown function: %(...)."),
    EXTERNALFUNC(ErrType.XPST, 17, "Unbound external function: %(...)."),
    WHICHJAVA(ErrType.XPST, 17, "Java function '%(...)' not found."),
    JAVAAMB(ErrType.XPST, 17, "Signature is ambiguous: '%(...)'."),
    INITJAVA(ErrType.XPST, 17, "Class cannot be initialized: %."),
    TYPEUNKNOWN(ErrType.XPST, 51, "Unknown type %."),
    CASTUNKNOWN(ErrType.XPST, 80, "Invalid cast type %."),
    NOURI(ErrType.XPST, 81, "No namespace declared for %."),
    NSMISS(ErrType.XPST, 81, "QName % has no namespace."),
    XPSEQ(ErrType.XPTY, 4, "Single item expected, % found."),
    XPINVCAST(ErrType.XPTY, 4, "Invalid cast from % to %: %."),
    XPINVTREAT(ErrType.XPTY, 4, "Cannot treat % as %: %."),
    XPTYPE(ErrType.XPTY, 4, "%: % expected, % found."),
    CALCTYPE(ErrType.XPTY, 4, "% not defined for % and %."),
    SIMPLDUR(ErrType.XPTY, 4, "%: only supported on subtypes of xs:duration, not %."),
    XPEMPTY(ErrType.XPTY, 4, "%: no empty sequence allowed."),
    XPEMPTYPE(ErrType.XPTY, 4, "%: % expected, empty sequence found."),
    XPDUR(ErrType.XPTY, 4, "%: duration expected, % found."),
    XPTYPECMP(ErrType.XPTY, 4, "% and % cannot be compared."),
    XPTYPENUM(ErrType.XPTY, 4, "%: number expected, % found."),
    XPNAME(ErrType.XPTY, 4, "Expecting name."),
    XPATT(ErrType.XPTY, 4, "Cannot add attributes to a document node."),
    XPNS(ErrType.XPTY, 4, "Cannot add namespaces to a document node."),
    CPIWRONG(ErrType.XPTY, 4, "Name has invalid type: '%'."),
    INVQNAME(ErrType.XPTY, 4, "Invalid QName: '%'."),
    INVARITY(ErrType.XPTY, 4, "Wrong number of arguments in %, expected %."),
    INVNCNAME(ErrType.XPTY, 4, "Invalid NCName: '%'."),
    INVPOS(ErrType.XPTY, 4, "Illegal argument position for %: %."),
    EVALNODESVALS(ErrType.XPTY, 18, "Result yields both nodes and atomic values."),
    NODESPATH(ErrType.XPTY, 19, "Context node required for %; % found."),
    CATTDUPL(ErrType.XQDY, 25, "Duplicate attribute '%'."),
    CPICONT(ErrType.XQDY, 26, "Processing instruction has invalid content: '%'."),
    CPIINVAL(ErrType.XQDY, 41, "Processing instruction has invalid name: '%'."),
    CAXML(ErrType.XQDY, 44, "XML prefix and namespace cannot be rebound."),
    CAINV(ErrType.XQDY, 44, "Invalid attribute prefix/namespace '%'."),
    CPIXML(ErrType.XQDY, 64, "Processing instruction has illegal name: '%'."),
    COMINVALID(ErrType.XQDY, 72, "Invalid comment."),
    INVNAME(ErrType.XQDY, 74, "Invalid name: '%'."),
    INVPREF(ErrType.XQDY, 74, "No namespace declared for %."),
    XGRP(ErrType.XQDY, 95, "No sequence allowed as grouping variable."),
    CEXML(ErrType.XQDY, 96, "XML prefix and namespace cannot be rebound."),
    CEINV(ErrType.XQDY, 96, "Invalid element prefix/namespace '%'."),
    CNXML(ErrType.XQDY, 101, "XML prefix and namespace cannot be rebound."),
    CNINV(ErrType.XQDY, 101, "Invalid prefix/namespace '%'."),
    DUPLNSCONS(ErrType.XQDY, 102, "Duplicate namespace declaration: '%'."),
    IMPLSCHEMA(ErrType.XQST, 9, "Schema import not supported."),
    NSCONS(ErrType.XQST, 22, "Constant namespace value expected."),
    XQUERYVER(ErrType.XQST, 31, "XQuery version '%' not supported."),
    DUPLBASE(ErrType.XQST, 32, "Duplicate 'base-uri' declaration."),
    DUPLNSDECL(ErrType.XQST, 33, "Duplicate declaration of prefix '%'."),
    FUNCDEFINED(ErrType.XQST, 34, "Duplicate declaration of function %(...)."),
    DUPLCOLL(ErrType.XQST, 38, "Duplicate 'collation' declaration."),
    COLLWHICH(ErrType.XQST, 38, "Unknown collation '%'."),
    FUNCDUPL(ErrType.XQST, 39, "Duplicate function argument %."),
    ATTDUPL(ErrType.XQST, 40, "Duplicate attribute '%'."),
    NAMERES(ErrType.XQST, 45, "Function %(...) uses reserved namespace."),
    ANNRES(ErrType.XQST, 45, "Annotation % uses reserved namespace."),
    DUPLMODULE(ErrType.XQST, 47, "Module is declared twice: '%'."),
    MODNS(ErrType.XQST, 48, "Declaration % does not match the module namespace."),
    VARDEFINE(ErrType.XQST, 49, "Duplicate declaration of %."),
    XPSTACK(ErrType.XQST, 54, "Stack Overflow: circular variable declaration?"),
    DUPLCOPYNS(ErrType.XQST, 55, "Duplicate 'copy-namespace' declaration."),
    NSEMPTY(ErrType.XQST, 57, "Namespace URI cannot be empty."),
    NOINST(ErrType.XQST, 59, "Could not instantiate module '%'."),
    NOMODULE(ErrType.XQST, 59, "Module \"%\" not found."),
    MODINIT(ErrType.XQST, 59, "Module '%' not initialized."),
    NOMODULEFILE(ErrType.XQST, 59, "Could not retrieve module '%'."),
    WRONGMODULE(ErrType.XQST, 59, "Wrong URI '%' in imported module '%'."),
    FUNNONS(ErrType.XQST, 60, "Namespace needed for function %(...)."),
    DUPLORD(ErrType.XQST, 65, "Duplicate 'ordering' declaration."),
    DUPLNS(ErrType.XQST, 66, "Duplicate 'default namespace' declaration."),
    DUPLCONS(ErrType.XQST, 67, "Duplicate 'construction' declaration."),
    DUPLBOUND(ErrType.XQST, 68, "Duplicate 'boundary-space' declaration."),
    DUPLORDEMP(ErrType.XQST, 69, "Duplicate 'order empty' declaration."),
    BINDXML(ErrType.XQST, 70, "Prefix '%' cannot be rebound."),
    BINDXMLURI(ErrType.XQST, 70, "'%' can only be bound to '%'."),
    DUPLNSDEF(ErrType.XQST, 71, "Duplicate declaration of prefix '%'."),
    IMPLVAL(ErrType.XQST, 75, "Validation not supported."),
    WHICHCOLL(ErrType.XQST, 76, "Unknown collation '%'."),
    NOPRAGMA(ErrType.XQST, 79, "Expecting pragma expression."),
    NSEMPTYURI(ErrType.XQST, 85, "Namespace URI cannot be empty."),
    XQUERYENC2(ErrType.XQST, 87, "Unknown encoding '%'."),
    NSMODURI(ErrType.XQST, 88, "Module namespace cannot be empty."),
    DUPLVAR(ErrType.XQST, 89, "Duplicate declaration of %."),
    INVCHARREF(ErrType.XQST, 90, "Invalid character reference '%'."),
    CIRCMODULE(ErrType.XQST, 93, "Circular module declaration."),
    GVARNOTDEFINED(ErrType.XQST, 94, "Undeclared grouping variable '%'."),
    INVDECFORM(ErrType.XQST, 97, "Invalid decimal-format property: %='%'."),
    DUPLDECFORM(ErrType.XQST, 98, "Duplicate use of decimal-format '%'."),
    DUPLITEM(ErrType.XQST, 99, "Duplicate declaration of context item."),
    DUPLUPD(ErrType.XQST, 106, "More than one updating annotation declared."),
    DUPLVIS(ErrType.XQST, 106, "More than one visibility annotation declared."),
    CTXINIT(ErrType.XQST, 107, "Context item depends on itself."),
    MODOUT(ErrType.XQST, 108, "No output declarations allowed in modules."),
    OUTWHICH(ErrType.XQST, 109, "Unknown serialization parameter: '%'."),
    OUTDUPL(ErrType.XQST, 110, "Duplicate declaration of 'output:%'."),
    DECDUPL(ErrType.XQST, 111, "Duplicate decimal-format declaration."),
    DECITEM(ErrType.XQST, 113, "Context item cannot be specified in module."),
    DECDUPLPROP(ErrType.XQST, 114, "Duplicate decimal-format property '%'."),
    NOATTALL(ErrType.XQTY, 24, "Attribute must follow the root element."),
    NONSALL(ErrType.XQTY, 24, "Namespaces must follow the root element."),
    CONSFUNC(ErrType.XQTY, 105, "Invalid content: %."),
    WRONGINT(ErrType.FOFD, 1340, "Wrong integer format: '%'."),
    OPTAFTER(ErrType.FOFD, 1340, "Optional digit follows mandatory digits: '%'."),
    DIFFMAND(ErrType.FOFD, 1340, "Mandatory digits must be of the same group: '%'."),
    GROUPADJ(ErrType.FOFD, 1340, "Adjacent grouping separators: '%'."),
    GROUPSTART(ErrType.FOFD, 1340, "Picture begins with grouping separator: '%'."),
    GROUPEND(ErrType.FOFD, 1340, "Picture ends with grouping separator: '%'."),
    NOMAND(ErrType.FOFD, 1340, "No mandatory digit specified: '%'."),
    PICDATE(ErrType.FOFD, 1340, "Invalid picture string: '%'."),
    ORDCLOSED(ErrType.FOFD, 1340, "Ordinal is not closed: '%'."),
    PICCOMP(ErrType.FOFD, 1350, "Invalid component in string: '%'."),
    RESNF(ErrType.FOUT, 1170, "Resource '%' cannot be retrieved."),
    FRAGID(ErrType.FOUT, 1170, "URI contains a fragment identifier: %"),
    INVURL(ErrType.FOUT, 1170, "URI is invalid: %"),
    WHICHENC(ErrType.FOUT, 1190, "Encoding '%' is not supported."),
    INVCHARS(ErrType.FOUT, 1190, "%."),
    WHICHCHARS(ErrType.FOUT, 1200, "Resource contains invalid input."),
    UPNOPAR(ErrType.XUDY, 9, "Target % has no parent."),
    UPNOTCOPIED(ErrType.XUDY, 14, "% was not created by copy clause."),
    UPMULTREN(ErrType.XUDY, 15, "Node can only be renamed once: %."),
    UPPATHREN(ErrType.XUDY, 15, "Path can only be renamed once: '%'."),
    UPMULTREPL(ErrType.XUDY, 16, "Node can only be replaced once: %."),
    UPMULTREPV(ErrType.XUDY, 17, "Node can only be replaced once: %"),
    UPATTDUPL(ErrType.XUDY, 21, "Duplicate attribute %."),
    UPNSCONFL(ErrType.XUDY, 23, "Conflicts with existing namespaces."),
    UPNSCONFL2(ErrType.XUDY, 24, "New namespaces conflict with each other."),
    UPSEQEMP(ErrType.XUDY, 27, "% target must not be empty."),
    UPPAREMPTY(ErrType.XUDY, 29, "Target has no parent node."),
    UPATTELM(ErrType.XUDY, 30, "Attributes cannot be inserted as child of a document."),
    UPURIDUP(ErrType.XUDY, 31, "URI '%' is addressed multiple times."),
    UPNOT(ErrType.XUST, 1, "%: no updating expression allowed."),
    UPCTX(ErrType.XUST, 1, "Context item may not declare an updating expression."),
    UPEXPECTT(ErrType.XUST, 2, "Updating expression expected in modify clause."),
    UPEXPECTF(ErrType.XUST, 2, "Function body must be an updating expression."),
    DUPLREVAL(ErrType.XUST, 3, "Duplicate 'revalidation' declaration."),
    NOREVAL(ErrType.XUST, 26, "Revalidation mode not supported."),
    UPFUNCTYPE(ErrType.XUST, 28, "No return type allowed in updating functions."),
    UPNOATTRPER(ErrType.XUTY, 4, "Attribute must follow the root element."),
    UPTRGTYP(ErrType.XUTY, 5, "Single element or document expected as insert target."),
    UPTRGTYP2(ErrType.XUTY, 6, "Single element, text, comment or pi expected as insert target."),
    UPTRGDELEMPT(ErrType.XUTY, 7, "Only nodes can be deleted."),
    UPTRGMULT(ErrType.XUTY, 8, "Single element, text, attribute, comment or pi expected as replace target."),
    UPWRELM(ErrType.XUTY, 10, "Replacing nodes must be no attribute nodes."),
    UPWRATTR(ErrType.XUTY, 11, "Replacing nodes must be attribute nodes."),
    UPWRTRGTYP(ErrType.XUTY, 12, "Single element, attribute or pi expected as rename target."),
    UPCOPYMULT(ErrType.XUTY, 13, "Source expression in copy clause must return a single node."),
    UPATTELM2(ErrType.XUTY, 22, "Insert target must be an element.");

    public final ErrType type;
    public final int num;
    public final String desc;

    private Err(ErrType t, int n2, String d) {
        this.type = t;
        this.num = n2;
        this.desc = d;
    }

    public QueryException thrw(InputInfo ii, Object ... ext) throws QueryException {
        throw new QueryException(ii, this, ext);
    }

    public SerializerException thrwSerial(Object ... ext) throws SerializerException {
        throw new SerializerException(new QueryException(null, this, ext));
    }

    public final QNm qname() {
        return this.type.qname(this.num);
    }

    public static QueryException diff(InputInfo ii, Item it1, Item it2) throws QueryException {
        throw (it1 == it2 ? TYPECMP : XPTYPECMP).thrw(ii, it1.type, it2.type);
    }

    public static QueryException cast(InputInfo ii, Type t, Value v) throws QueryException {
        throw XPINVCAST.thrw(ii, v.type, t, v);
    }

    public static QueryException promote(InputInfo ii, SeqType t, Value v) throws QueryException {
        throw XPINVTREAT.thrw(ii, v.description(), t, v);
    }

    public static QueryException type(ParseExpr e, Type t, Item it) throws QueryException {
        throw XPTYPE.thrw(e.info, e.description(), t, it.type);
    }

    public static QueryException number(ParseExpr e, Item it) throws QueryException {
        throw XPTYPENUM.thrw(e.info, e.description(), it.type);
    }

    public static QueryException value(InputInfo ii, Type t, Object v) throws QueryException {
        throw INVALUE.thrw(ii, t, v);
    }

    public String toString() {
        return String.format("%s%04d", new Object[]{this.type, this.num});
    }

    public static enum ErrType {
        BASX(QueryText.BXERR, QueryText.BXERRORS),
        BXCL(QueryText.BXERR, QueryText.BXERRORS),
        BXCO(QueryText.BXERR, QueryText.BXERRORS),
        BXDB(QueryText.BXERR, QueryText.BXERRORS),
        BXFT(QueryText.BXERR, QueryText.BXERRORS),
        BXJS(QueryText.BXERR, QueryText.BXERRORS),
        BXPR(QueryText.BXERR, QueryText.BXERRORS),
        BXRE(QueryText.BXERR, QueryText.BXERRORS),
        BXSQ(QueryText.BXERR, QueryText.BXERRORS),
        BXVA(QueryText.BXERR, QueryText.BXERRORS),
        BXXQ(QueryText.BXERR, QueryText.BXERRORS),
        HASH(QueryText.BXERR, QueryText.BXERRORS),
        CX(QueryText.EXPERR, QueryText.EXPERROR),
        FILE(QueryText.EXPERR, QueryText.EXPERROR),
        HC(QueryText.EXPERR, QueryText.EXPERROR),
        ZIP(QueryText.EXPERR, QueryText.EXPERROR),
        ARCH(QueryText.EXPERR, QueryText.EXPERROR),
        FOAR,
        FOCA,
        FOCH,
        FODC,
        FODF,
        FODT,
        FOFD,
        FOER,
        FONS,
        FORG,
        FORX,
        FOTY,
        FOUP,
        FOUT,
        FTDY,
        FTST,
        SEPM,
        SERE,
        SESU,
        XPDY,
        XPST,
        XPTY,
        XQDY,
        XQST,
        XQTY,
        XUDY,
        XUST,
        XUTY;

        public final String prefix;
        public final byte[] uri;

        private ErrType(byte[] pref, byte[] euri) {
            this.prefix = Token.string(pref);
            this.uri = euri;
        }

        private ErrType() {
            this(QueryText.ERR, QueryText.ERRORURI);
        }

        public final QNm qname(int num) {
            return new QNm(String.format("%s:%s%04d", this.prefix, this.name(), num), this.uri);
        }
    }
}

