/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.archive;

import java.io.IOException;
import java.util.zip.ZipEntry;
import org.basex.io.in.BufferInput;
import org.basex.io.in.LookupInput;
import org.basex.io.out.ArrayOutput;
import org.basex.query.QueryException;
import org.basex.query.util.Err;
import org.basex.query.util.archive.GZIPIn;
import org.basex.query.util.archive.ZIPIn;
import org.basex.util.InputInfo;

public abstract class ArchiveIn {
    private final byte[] data = new byte[4096];

    public static ArchiveIn get(BufferInput bi, InputInfo info) throws QueryException {
        try {
            LookupInput li = new LookupInput(bi);
            if (li.lookup() == 80) {
                return new ZIPIn(li);
            }
            if (li.lookup() == 31) {
                return new GZIPIn(li);
            }
        }
        catch (IOException ex) {
            try {
                bi.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw Err.ARCH_FAIL.thrw(info, ex);
        }
        throw Err.ARCH_UNKNOWN.thrw(info, new Object[0]);
    }

    public abstract boolean more() throws IOException;

    public abstract ZipEntry entry();

    public abstract String format();

    public abstract int read(byte[] var1) throws IOException;

    public byte[] read() throws IOException {
        int c;
        ArrayOutput ao = new ArrayOutput();
        while ((c = this.read(this.data)) != -1) {
            ao.write(this.data, 0, c);
        }
        return ao.toArray();
    }

    public abstract void close();
}

