/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.archive;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import org.basex.query.util.archive.ArchiveIn;
import org.basex.util.Util;

public final class GZIPIn
extends ArchiveIn {
    private final GZIPInputStream zis;
    private boolean more;

    public GZIPIn(InputStream is) throws IOException {
        this.zis = new GZIPInputStream(is);
    }

    @Override
    public boolean more() throws IOException {
        return this.more ^= true;
    }

    @Override
    public ZipEntry entry() {
        ZipEntry ze = new ZipEntry("");
        ze.setMethod(8);
        return ze;
    }

    @Override
    public int read(byte[] d) throws IOException {
        return this.zis.read(d);
    }

    @Override
    public String format() {
        return "gzip";
    }

    @Override
    public void close() {
        try {
            this.zis.close();
        }
        catch (IOException ex) {
            Util.debug(ex);
        }
    }
}

