/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.archive;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.basex.query.util.archive.ArchiveIn;
import org.basex.util.Util;

public final class ZIPIn
extends ArchiveIn {
    private final ZipInputStream zis;
    private ZipEntry ze;

    public ZIPIn(InputStream is) {
        this.zis = new ZipInputStream(is);
    }

    @Override
    public boolean more() throws IOException {
        this.ze = this.zis.getNextEntry();
        return this.ze != null;
    }

    @Override
    public ZipEntry entry() {
        return this.ze;
    }

    @Override
    public int read(byte[] d) throws IOException {
        return this.zis.read(d);
    }

    @Override
    public String format() {
        return "zip";
    }

    @Override
    public void close() {
        try {
            this.zis.close();
        }
        catch (IOException ex) {
            Util.debug(ex);
        }
    }
}

