/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.format;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.query.QueryException;
import org.basex.query.util.Err;
import org.basex.query.util.format.FormatUtil;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class FormatParser
extends FormatUtil {
    private static final Pattern WIDTH = Pattern.compile("(\\*|\\d+)(-(\\*|\\d+))?");
    private final InputInfo info;
    private final byte[] pic;
    private final byte[] def;
    private final boolean ext;
    FormatUtil.Case cs;
    byte[] primary;
    int digit;
    byte[] ordinal;
    int min;
    int max = Integer.MAX_VALUE;

    public FormatParser(byte[] p, byte[] df, InputInfo ii) throws QueryException {
        int w;
        this.info = ii;
        this.pic = p.length != 0 ? p : df;
        this.ext = df != null;
        this.def = this.ext ? df : Token.ONE;
        byte[] pm = this.mod();
        if (this.ext && (w = Token.lastIndexOf(pm, 44)) != -1) {
            String mc;
            int i;
            byte[] wd = Token.substring(pm, w + 1);
            pm = Token.substring(pm, 0, w);
            Matcher m = WIDTH.matcher(Token.string(wd));
            if (!m.find()) {
                Err.PICDATE.thrw(ii, new Object[]{wd});
            }
            if ((i = Token.toInt(m.group(1))) != Integer.MIN_VALUE) {
                this.min = i;
            }
            int n = i = (mc = m.group(3)) != null ? Token.toInt(mc) : Integer.MIN_VALUE;
            if (i != Integer.MIN_VALUE) {
                this.max = i;
            }
        }
        if (pm.length == 0) {
            pm = Token.ONE;
        }
        this.cs = Token.cl(pm, 0) < pm.length ? FormatUtil.Case.STANDARD : ((FormatParser.ch(pm, 0) & 0x20) == 0 ? FormatUtil.Case.UPPER : FormatUtil.Case.LOWER);
        this.primary = Token.lc(pm);
        if (this.digit == 0) {
            this.digit = FormatParser.ch(this.primary, 0);
        }
    }

    private byte[] mod() throws QueryException {
        int l = this.pic.length;
        byte[] pm = null;
        int pos = Token.cl(this.pic, 0);
        int ch = FormatParser.ch(this.pic, 0);
        if (FormatParser.sequence(ch) == null && (ch < 9312 || ch > 9371) && ch != KANJI[1] && (ch | 0x20) != 105) {
            if ((ch | 0x20) == 119 || (ch | 0x20) == 110 && this.ext) {
                if ((ch & 0x20) == 0 && FormatParser.ch(this.pic, pos) == (ch | 0x20)) {
                    pos += Token.cl(this.pic, pos);
                }
            } else if (ch == 44) {
                pos = 0;
            } else {
                int z = -1;
                boolean group = false;
                for (pos = 0; pos < l; pos += Token.cl(this.pic, pos)) {
                    ch = FormatParser.ch(this.pic, pos);
                    if (z == -1) {
                        z = FormatParser.zeroes(ch);
                        if (z != -1) {
                            this.digit = z;
                            group = false;
                            continue;
                        }
                        if (ch == 35) {
                            group = false;
                            continue;
                        }
                        if (Character.isLetter(ch)) {
                            pm = this.def;
                            pos += Token.cl(this.pic, pos);
                            break;
                        }
                        if (pos == 0) {
                            Err.GROUPSTART.thrw(this.info, new Object[]{this.pic});
                        }
                        if (group) {
                            Err.GROUPADJ.thrw(this.info, new Object[]{this.pic});
                        }
                        group = true;
                        continue;
                    }
                    if (Character.isLetter(ch)) {
                        pm = Token.substring(this.pic, 0, pos);
                        break;
                    }
                    if (ch >= z && ch <= z + 9) {
                        group = false;
                        continue;
                    }
                    if (FormatParser.zeroes(ch) != -1) {
                        Err.DIFFMAND.thrw(this.info, new Object[]{this.pic});
                    }
                    if (ch == 35) {
                        Err.OPTAFTER.thrw(this.info, new Object[]{this.pic});
                    }
                    if (group) {
                        Err.GROUPADJ.thrw(this.info, new Object[]{this.pic});
                    }
                    group = true;
                }
                if (z == -1) {
                    Err.NOMAND.thrw(this.info, new Object[]{this.pic});
                }
                if (group) {
                    Err.GROUPEND.thrw(this.info, new Object[]{this.pic});
                }
            }
        }
        if (pm == null) {
            pm = Token.substring(this.pic, 0, pos);
        }
        if (pos < l) {
            if (FormatParser.ch(this.pic, pos) == 111) {
                TokenBuilder tb = new TokenBuilder();
                if (FormatParser.ch(this.pic, ++pos) == 40) {
                    while (FormatParser.ch(this.pic, ++pos) != 41) {
                        if (pos == l) {
                            Err.ORDCLOSED.thrw(this.info, new Object[]{this.pic});
                        }
                        tb.add(FormatParser.ch(this.pic, pos));
                    }
                    ++pos;
                }
                this.ordinal = tb.finish();
            } else if (FormatParser.ch(this.pic, pos) == 116) {
                ++pos;
            }
            if (pos < l) {
                if (FormatParser.ch(this.pic, pos) != 44) {
                    Err.PICCOMP.thrw(this.info, new Object[]{this.pic});
                }
                pm = Token.concat(pm, Token.substring(this.pic, pos));
            }
        }
        return pm;
    }
}

