/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Locale;
import org.basex.core.Prop;
import org.basex.io.MimeTypes;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerProp;
import org.basex.query.QueryException;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.iter.ValueIter;
import org.basex.query.util.Err;
import org.basex.query.util.http.HTTPRequest;
import org.basex.query.util.http.HTTPRequestParser;
import org.basex.query.util.http.HTTPResponse;
import org.basex.query.util.http.HTTPText;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Hex;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.util.Base64;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.TokenMap;

public final class HTTPClient {
    private final InputInfo info;
    private final Prop prop;

    public HTTPClient(InputInfo ii, Prop pr) {
        this.info = ii;
        this.prop = pr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iter sendRequest(byte[] href, ANode request, ValueBuilder bodies) throws QueryException {
        try {
            byte[] dest;
            if (request == null) {
                if (href == null || href.length == 0) {
                    Err.HC_PARAMS.thrw(this.info, new Object[0]);
                }
                HttpURLConnection conn = this.openConnection(Token.string(href));
                try {
                    ValueIter valueIter = new HTTPResponse(this.info, this.prop).getResponse(conn, Bln.FALSE.string(), null);
                    return valueIter;
                }
                finally {
                    conn.disconnect();
                }
            }
            HTTPRequest r = new HTTPRequestParser(this.info).parse(request, bodies);
            byte[] byArray = dest = href == null ? r.attrs.get(HTTPText.HREF) : href;
            if (dest == null) {
                Err.HC_URL.thrw(this.info, new Object[0]);
            }
            HttpURLConnection conn = this.openConnection(Token.string(dest));
            try {
                this.setConnectionProps(conn, r);
                this.setRequestHeaders(conn, r);
                if (r.bodyContent.size() != 0L || r.parts.size() != 0) {
                    HTTPClient.setContentType(conn, r);
                    this.setRequestContent(conn.getOutputStream(), r);
                }
                ValueIter valueIter = new HTTPResponse(this.info, this.prop).getResponse(conn, r.attrs.get(HTTPText.STATUS_ONLY), r.attrs.get(HTTPText.OVERRIDE_MEDIA_TYPE));
                return valueIter;
            }
            finally {
                conn.disconnect();
            }
        }
        catch (MalformedURLException ex) {
            throw Err.HC_ERROR.thrw(this.info, "Invalid URL");
        }
        catch (ProtocolException ex) {
            throw Err.HC_ERROR.thrw(this.info, "Invalid HTTP method");
        }
        catch (IOException ex) {
            Util.debug(ex);
            throw Err.HC_ERROR.thrw(this.info, ex);
        }
    }

    private HttpURLConnection openConnection(String dest) throws QueryException, IOException {
        URL url = new URL(dest);
        if (!Token.eqic(url.getProtocol(), "HTTP", "HTTPS")) {
            Err.HC_ERROR.thrw(this.info, "Invalid URL");
        }
        return (HttpURLConnection)url.openConnection();
    }

    private void setConnectionProps(HttpURLConnection conn, HTTPRequest r) throws ProtocolException, QueryException {
        byte[] redirect;
        if (r.bodyContent != null || r.parts.size() != 0) {
            conn.setDoOutput(true);
        }
        conn.setRequestMethod(Token.string(r.attrs.get(HTTPText.METHOD)).toUpperCase(Locale.ENGLISH));
        byte[] timeout = r.attrs.get(HTTPText.TIMEOUT);
        if (timeout != null) {
            conn.setConnectTimeout(Integer.parseInt(Token.string(timeout)));
        }
        if ((redirect = r.attrs.get(HTTPText.FOLLOW_REDIRECT)) != null) {
            HttpURLConnection.setFollowRedirects(Bln.parse(redirect, this.info));
        }
    }

    private static void setContentType(HttpURLConnection conn, HTTPRequest r) {
        byte[] contTypeHdr = r.headers.get(Token.lc(Token.token("Content-Type")));
        if (contTypeHdr != null) {
            conn.setRequestProperty("Content-Type", Token.string(contTypeHdr));
        } else {
            String mt = Token.string(r.payloadAttrs.get(HTTPText.MEDIA_TYPE));
            if (r.isMultipart) {
                byte[] b = r.payloadAttrs.get(HTTPText.BOUNDARY);
                byte[] boundary = b != null ? b : HTTPText.DEFAULT_BOUND;
                TokenBuilder tb = new TokenBuilder();
                mt = tb.add(mt).add("; ").add(HTTPText.BOUNDARY).add(61).add(boundary).toString();
            }
            conn.setRequestProperty("Content-Type", mt);
        }
    }

    private void setRequestHeaders(HttpURLConnection conn, HTTPRequest r) throws QueryException {
        byte[][] headerNames;
        for (byte[] headerName : headerNames = r.headers.keys()) {
            conn.addRequestProperty(Token.string(headerName), Token.string(r.headers.get(headerName)));
        }
        byte[] sendAuth = r.attrs.get(HTTPText.SEND_AUTHORIZATION);
        if (sendAuth != null && Bln.parse(sendAuth, this.info)) {
            conn.setRequestProperty("Authorization", HTTPClient.encodeCredentials(Token.string(r.attrs.get(HTTPText.USERNAME)), Token.string(r.attrs.get(HTTPText.PASSWORD))));
        }
    }

    public void setRequestContent(OutputStream out, HTTPRequest r) throws IOException, QueryException {
        if (r.isMultipart) {
            this.writeMultipart(r, out);
        } else {
            this.writePayload(r.bodyContent, r.payloadAttrs, out);
        }
        out.close();
    }

    private static String encodeCredentials(String u, String p) {
        return "Basic " + Base64.encode(u + ':' + p);
    }

    private void writePayload(ValueBuilder payload, TokenMap payloadAtts, OutputStream out) throws IOException, QueryException {
        byte[] t = payloadAtts.get(HTTPText.MEDIA_TYPE);
        String type = t == null ? null : Token.string(t);
        byte[] src = payloadAtts.get(HTTPText.SRC);
        if (src == null) {
            byte[] m = payloadAtts.get(HTTPText.METHOD);
            if (m == null) {
                m = Token.eq(type, "application/html+xml") ? Token.token("xhtml") : (MimeTypes.isXML(type) ? Token.token("xml") : (Token.eq(type, "text/html") ? Token.token("html") : (type != null && type.startsWith("text/") ? Token.token("text") : Token.token("xml"))));
            }
            if (Token.eq(m, HTTPText.BASE64)) {
                this.writeBase64(payload, out);
            } else if (Token.eq(m, HTTPText.HEXBIN)) {
                this.writeHex(payload, out);
            } else {
                HTTPClient.write(payload, payloadAtts, m, out);
            }
        } else {
            HTTPClient.writeResource(src, out);
        }
    }

    private void writeBase64(ValueBuilder payload, OutputStream out) throws IOException, QueryException {
        int i = 0;
        while ((long)i < payload.size()) {
            Item item = payload.get(i);
            if (item instanceof B64) {
                out.write(((B64)item).toJava());
            } else {
                out.write(new B64(item.string(this.info)).toJava());
            }
            ++i;
        }
    }

    private void writeHex(ValueBuilder payload, OutputStream out) throws IOException, QueryException {
        int i = 0;
        while ((long)i < payload.size()) {
            Item item = payload.get(i);
            if (item instanceof Hex) {
                out.write(((Hex)item).toJava());
            } else {
                out.write(new Hex(item.string(this.info)).toJava());
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(ValueBuilder payload, TokenMap attrs, byte[] method, OutputStream out) throws IOException {
        TokenBuilder tb = new TokenBuilder();
        tb.add(HTTPText.METHOD).add(61).add(method);
        for (byte[] key : attrs.keys()) {
            if (Token.eq(key, HTTPText.SRC)) continue;
            tb.add(44).add(key).add(61).add(attrs.get(key));
        }
        SerializerProp sp = new SerializerProp(tb.toString());
        Serializer ser = Serializer.get(out, sp);
        try {
            payload.serialize(ser);
        }
        finally {
            ser.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeResource(byte[] src, OutputStream out) throws IOException {
        InputStream bis = new URL(Token.string(src)).openStream();
        try {
            int len;
            byte[] buf = new byte[256];
            while ((len = bis.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            bis.close();
        }
    }

    private void writeMultipart(HTTPRequest r, OutputStream out) throws IOException, QueryException {
        byte[] boundary = r.payloadAttrs.get(HTTPText.BOUNDARY);
        for (HTTPRequest.Part part : r.parts) {
            this.writePart(part, out, boundary);
        }
        out.write(new TokenBuilder("--").add(boundary).add("--").add(HTTPText.CRLF).finish());
    }

    private void writePart(HTTPRequest.Part part, OutputStream out, byte[] boundary) throws IOException, QueryException {
        TokenBuilder boundTb = new TokenBuilder();
        boundTb.add("--").add(boundary).add(HTTPText.CRLF);
        out.write(boundTb.finish());
        for (byte[] headerName : part.headers.keys()) {
            TokenBuilder hdrTb = new TokenBuilder();
            hdrTb.add(headerName).add(": ").add(part.headers.get(headerName)).add(HTTPText.CRLF);
            out.write(hdrTb.finish());
        }
        out.write(HTTPText.CRLF);
        this.writePayload(part.bodyContent, part.bodyAttrs, out);
        out.write(HTTPText.CRLF);
    }
}

