/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.http;

import java.util.ArrayList;
import org.basex.query.QueryException;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.util.Err;
import org.basex.query.util.http.HTTPRequest;
import org.basex.query.util.http.HTTPText;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.TokenMap;

public final class HTTPRequestParser {
    private final InputInfo info;

    public HTTPRequestParser(InputInfo ii) {
        this.info = ii;
    }

    public HTTPRequest parse(ANode request, ValueBuilder bodies) throws QueryException {
        HTTPRequest r = new HTTPRequest();
        HTTPRequestParser.parseAttrs(request, r.attrs);
        this.checkRequest(r);
        ANode payload = HTTPRequestParser.parseHdrs(request.children(), r.headers);
        byte[] method = Token.lc(r.attrs.get(HTTPText.METHOD));
        if (Token.eq(method, HTTPText.TRACE, HTTPText.DELETE) && (payload != null || bodies != null)) {
            Err.HC_REQ.thrw(this.info, "Body not expected for method " + Token.string(method));
        }
        if (payload != null) {
            QNm pl = payload.qname();
            if (pl.eq(HTTPText.HTTP_BODY)) {
                Item it = null;
                if (bodies != null) {
                    if (bodies.size() != 1L) {
                        Err.HC_REQ.thrw(this.info, "Number of items with request body content differs from number of body descriptors.");
                    }
                    it = bodies.next();
                }
                this.parseBody(payload, it, r.payloadAttrs, r.bodyContent);
                r.isMultipart = false;
            } else if (pl.eq(HTTPText.HTTP_MULTIPART)) {
                int i = 0;
                AxisMoreIter ch = payload.children();
                while (ch.next() != null) {
                    ++i;
                }
                if (bodies != null && bodies.size() != (long)i) {
                    Err.HC_REQ.thrw(this.info, "Number of items with request body content differs from number of body descriptors.");
                }
                this.parseMultipart(payload, bodies, r.payloadAttrs, r.parts);
                r.isMultipart = true;
            } else {
                Err.HC_REQ.thrw(this.info, "Unknown payload element " + pl);
            }
        }
        return r;
    }

    private static void parseAttrs(ANode element, TokenMap attrs) {
        ANode attr;
        AxisMoreIter elAttrs = element.attributes();
        while ((attr = elAttrs.next()) != null) {
            attrs.add(attr.name(), attr.string());
        }
    }

    private static ANode parseHdrs(AxisMoreIter i, TokenMap hdrs) {
        ANode n;
        block0: while ((n = i.next()) != null) {
            ANode attr;
            QNm nm = n.qname();
            if (nm == null) continue;
            if (!nm.eq(HTTPText.HTTP_HEADER)) break;
            AxisMoreIter hdrAttrs = n.attributes();
            byte[] name = null;
            byte[] value = null;
            while ((attr = hdrAttrs.next()) != null) {
                QNm qn = attr.qname();
                if (qn.eq(HTTPText.Q_NAME)) {
                    name = attr.string();
                }
                if (qn.eq(HTTPText.Q_VALUE)) {
                    value = attr.string();
                }
                if (name == null || name.length == 0 || value == null || value.length == 0) continue;
                hdrs.add(name, value);
                continue block0;
            }
        }
        return n;
    }

    private void parseBody(ANode body, Item contItem, TokenMap attrs, ValueBuilder bodyContent) throws QueryException {
        HTTPRequestParser.parseAttrs(body, attrs);
        this.checkBody(body, attrs);
        if (attrs.get(HTTPText.SRC) == null) {
            if (contItem == null) {
                for (ANode n : body.children()) {
                    bodyContent.add(n);
                }
            } else {
                bodyContent.add(contItem);
            }
        }
    }

    private void parseMultipart(ANode multipart, ValueBuilder contItems, TokenMap attrs, ArrayList<HTTPRequest.Part> parts) throws QueryException {
        HTTPRequestParser.parseAttrs(multipart, attrs);
        if (attrs.get(HTTPText.MEDIA_TYPE) == null) {
            Err.HC_REQ.thrw(this.info, "Attribute media-type of http:multipart is mandatory");
        }
        AxisMoreIter i = multipart.children();
        if (contItems == null) {
            ANode n;
            while ((n = i.next()) != null) {
                parts.add(this.parsePart(n, null));
            }
        } else {
            ANode n;
            while ((n = i.next()) != null) {
                parts.add(this.parsePart(n, contItems.next()));
            }
        }
    }

    private HTTPRequest.Part parsePart(ANode part, Item contItem) throws QueryException {
        HTTPRequest.Part p = new HTTPRequest.Part();
        ANode partBody = HTTPRequestParser.parseHdrs(part.children(), p.headers);
        this.parseBody(partBody, contItem, p.bodyAttrs, p.bodyContent);
        return p;
    }

    private void checkRequest(HTTPRequest r) throws QueryException {
        byte[] sendAuth;
        if (r.attrs.get(HTTPText.METHOD) == null) {
            Err.HC_REQ.thrw(this.info, "Attribute method is mandatory");
        }
        if ((sendAuth = r.attrs.get(HTTPText.SEND_AUTHORIZATION)) != null && Boolean.parseBoolean(Token.string(sendAuth))) {
            byte[] un = r.attrs.get(HTTPText.USERNAME);
            byte[] pw = r.attrs.get(HTTPText.PASSWORD);
            if (un == null && pw != null || un != null && pw == null || un == null && pw == null) {
                Err.HC_REQ.thrw(this.info, "Provided credentials are invalid");
            }
        }
    }

    private void checkBody(ANode body, TokenMap bodyAttrs) throws QueryException {
        if (bodyAttrs.get(HTTPText.MEDIA_TYPE) == null) {
            Err.HC_REQ.thrw(this.info, "Attribute media-type of http:body is mandatory");
        }
        if (bodyAttrs.get(HTTPText.SRC) != null && (bodyAttrs.size() > 2 || body.children().more())) {
            Err.HC_ATTR.thrw(this.info, new Object[0]);
        }
    }
}

