/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.json;

import org.basex.query.QueryException;
import org.basex.query.util.Err;
import org.basex.query.util.json.JArray;
import org.basex.query.util.json.JBoolean;
import org.basex.query.util.json.JNull;
import org.basex.query.util.json.JNumber;
import org.basex.query.util.json.JObject;
import org.basex.query.util.json.JString;
import org.basex.query.util.json.JStruct;
import org.basex.query.util.json.JValue;
import org.basex.util.InputInfo;
import org.basex.util.InputParser;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

final class JSONParser
extends InputParser {
    private static final String INVALID = "Invalid character: \"%\"";
    private static final String INVALEXP = "Char \"%\" found, % expected";
    private final TokenBuilder tb = new TokenBuilder();
    private final InputInfo info;

    public JSONParser(byte[] in, InputInfo inf) {
        super(Token.string(in));
        this.info = inf;
    }

    public JStruct parse() throws QueryException {
        JStruct root = this.object();
        if (root == null) {
            root = this.array();
        }
        if (root == null) {
            this.error(INVALEXP, Character.valueOf(this.curr()), "\"{\" or \"[\"");
        }
        this.skipWS();
        if (this.more()) {
            this.error(INVALEXP, Character.valueOf(this.curr()), "end of file");
        }
        return root;
    }

    private JObject object() throws QueryException {
        if (!this.wsConsume(123)) {
            return null;
        }
        JObject o = new JObject();
        do {
            byte[] key;
            if ((key = this.str()) == null) {
                if (o.size() == 0) break;
                this.error(INVALEXP, Character.valueOf(this.curr()), Character.valueOf('\"'));
                break;
            }
            this.wsCheck(':');
            o.add(key, this.value(true));
        } while (this.wsConsume(44));
        this.wsCheck('}');
        return o;
    }

    private JArray array() throws QueryException {
        if (!this.wsConsume(91)) {
            return null;
        }
        JArray a = new JArray();
        do {
            JValue val;
            if ((val = this.value(a.size() != 0)) == null) continue;
            a.add(val);
        } while (this.wsConsume(44));
        this.wsCheck(']');
        return a;
    }

    private JValue value(boolean mand) throws QueryException {
        this.skipWS();
        char ch = this.curr();
        if (Token.digit(ch) || ch == '-') {
            return new JNumber(this.number());
        }
        if (ch == '\"') {
            return new JString(this.str());
        }
        if (ch == '{') {
            return this.object();
        }
        if (ch == '[') {
            return this.array();
        }
        if (ch == 't' || ch == 'f') {
            return new JBoolean(this.bool());
        }
        if (ch == 'n') {
            for (byte b : Token.NULL) {
                this.check((char)b);
            }
            return new JNull();
        }
        if (mand) {
            this.error(INVALEXP, Character.valueOf(this.curr()), Character.valueOf('\"'));
        }
        return null;
    }

    private byte[] str() throws QueryException {
        if (!this.wsConsume(34)) {
            return null;
        }
        this.tb.reset();
        while (this.more()) {
            int ch = this.consume();
            if (ch == 34) {
                return this.tb.finish();
            }
            if (ch == 92) {
                ch = this.consume();
                if (ch == 117) {
                    int i = 0;
                    for (int s = 0; s < 4; ++s) {
                        ch = this.consume();
                        i <<= 4;
                        if (ch >= 48 && ch <= 57) {
                            i += ch - 48;
                            continue;
                        }
                        if (ch >= 65 && ch <= 70) {
                            i += ch - 55;
                            continue;
                        }
                        if (ch >= 97 && ch <= 102) {
                            i += ch - 87;
                            continue;
                        }
                        this.error(INVALID, ch, "hex digit");
                    }
                    ch = i;
                } else if (ch == 98) {
                    ch = 8;
                } else if (ch == 102) {
                    ch = 12;
                } else if (ch == 110) {
                    ch = 10;
                } else if (ch == 114) {
                    ch = 13;
                } else if (ch == 116) {
                    ch = 9;
                } else if ("\\\"/".indexOf(ch) == -1) {
                    this.error(INVALID, "\\" + (char)ch);
                }
            }
            this.tb.add(ch);
        }
        throw this.error(INVALEXP, 0, Character.valueOf('\"'));
    }

    private byte[] number() throws QueryException {
        this.tb.reset();
        if (this.curr() == '-') {
            this.tb.add(this.consume());
        }
        if (this.curr() == '0') {
            this.tb.add(this.consume());
        } else {
            this.digits();
        }
        if (this.curr() == '.') {
            this.tb.add(this.consume());
            this.digits();
        }
        if (this.curr() == 'e' || this.curr() == 'E') {
            this.tb.add(this.consume());
            if (this.curr() == '+' || this.curr() == '-') {
                this.tb.add(this.consume());
            }
            this.digits();
        }
        return this.tb.finish();
    }

    private byte[] bool() throws QueryException {
        if (this.curr() == 't') {
            for (byte b : Token.TRUE) {
                this.check((char)b);
            }
            return Token.TRUE;
        }
        for (byte b : Token.FALSE) {
            this.check((char)b);
        }
        return Token.FALSE;
    }

    private void digits() throws QueryException {
        if (!Token.digit(this.curr())) {
            throw this.error(INVALEXP, Character.valueOf(this.curr()), "digit");
        }
        do {
            this.tb.add(this.consume());
        } while (Token.digit(this.curr()));
    }

    private boolean wsConsume(int c) {
        this.skipWS();
        return this.consume(c);
    }

    private void skipWS() {
        char c;
        while (this.more() && (c = this.curr()) != '\u0000' && c <= ' ') {
            ++this.ip;
        }
    }

    private void wsCheck(char ch) throws QueryException {
        if (!this.wsConsume(ch)) {
            this.error(INVALEXP, Character.valueOf(this.curr()), "\"" + ch + '\"');
        }
    }

    private void check(char ch) throws QueryException {
        if (!this.consume(ch)) {
            this.error(INVALEXP, Character.valueOf(this.curr()), "\"" + ch + '\"');
        }
    }

    private QueryException error(String msg, Object ... ext) throws QueryException {
        int[] lc = new InputInfo(this).lineCol();
        throw Err.BXJS_PARSE.thrw(this.info, lc[0], lc[1], Util.inf(msg, ext));
    }
}

