/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.pkg;

import java.io.IOException;
import org.basex.core.Context;
import org.basex.io.IO;
import org.basex.query.QueryException;
import org.basex.query.util.Err;
import org.basex.query.util.pkg.JarDesc;
import org.basex.query.util.pkg.PkgText;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class JarParser {
    private final Context context;
    private final InputInfo info;

    public JarParser(Context ctx, InputInfo ii) {
        this.context = ctx;
        this.info = ii;
    }

    public JarDesc parse(IO io) throws QueryException {
        JarDesc desc = new JarDesc();
        try {
            ANode node = new DBNode(io, this.context.prop).children().next();
            for (ANode next : node.children()) {
                QNm name = next.qname();
                if (Token.eq(PkgText.JAR, name.local())) {
                    desc.jars.add(next.string());
                    continue;
                }
                if (!Token.eq(PkgText.CLASS, name.local())) continue;
                desc.classes.add(next.string());
            }
            if (desc.jars.isEmpty()) {
                Err.BXRE_JARDESC.thrw(this.info, "No jars specified");
            } else if (desc.classes.isEmpty()) {
                Err.BXRE_JARDESC.thrw(this.info, "No public classes specified");
            }
            return desc;
        }
        catch (IOException ex) {
            throw Err.BXRE_JARFAIL.thrw(this.info, ex);
        }
    }
}

