/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.pkg;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.basex.core.Context;
import org.basex.core.MainProp;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.query.QueryException;
import org.basex.query.QueryModule;
import org.basex.query.QueryParser;
import org.basex.query.QueryText;
import org.basex.query.util.Err;
import org.basex.query.util.pkg.JarDesc;
import org.basex.query.util.pkg.JarParser;
import org.basex.query.util.pkg.Package;
import org.basex.query.util.pkg.PkgParser;
import org.basex.query.util.pkg.PkgText;
import org.basex.query.util.pkg.PkgValidator;
import org.basex.util.InputInfo;
import org.basex.util.JarLoader;
import org.basex.util.Reflect;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.Version;
import org.basex.util.hash.TokenSet;

public final class ModuleLoader {
    private static final ClassLoader LOADER = Thread.currentThread().getContextClassLoader();
    private final ArrayList<URL> urls = new ArrayList();
    private ClassLoader loader = LOADER;
    private HashMap<Object, ArrayList<Method>> javaModules;
    private final Context context;

    public ModuleLoader(Context ctx) {
        this.context = ctx;
    }

    public void close() {
        if (this.loader instanceof JarLoader) {
            ((JarLoader)this.loader).close();
        }
    }

    public boolean addImport(byte[] uri, InputInfo ii, QueryParser qp) throws QueryException {
        boolean java;
        String uriPath;
        TokenSet pkgs = this.context.repo.nsDict().get(uri);
        if (pkgs != null) {
            Version ver = null;
            byte[] nm = null;
            for (byte[] name : pkgs) {
                Version v = new Version(Package.version(name));
                if (ver != null && v.compareTo(ver) <= 0) continue;
                ver = v;
                nm = name;
            }
            if (nm != null) {
                this.addRepo(nm, new TokenSet(), new TokenSet(), ii, qp);
                return true;
            }
        }
        if ((uriPath = ModuleLoader.uri2path(Token.string((java = Token.startsWith(uri, QueryText.JAVAPREF)) ? Token.substring(uri, QueryText.JAVAPREF.length) : uri))) == null) {
            return false;
        }
        String path = this.context.mprop.get(MainProp.REPOPATH) + uriPath;
        if (IO.suffix(path).isEmpty()) {
            if (!java) {
                for (String suf : IO.XQSUFFIXES) {
                    if (!this.addModule(new IOFile(path + suf), uri, qp)) continue;
                    return true;
                }
            }
            this.addJar(new IOFile(path + ".jar"));
        } else {
            IOFile file = new IOFile(path);
            if (!java && file.hasSuffix(IO.XQSUFFIXES)) {
                return this.addModule(file, uri, qp);
            }
            if (file.hasSuffix(".jar")) {
                this.addJar(file);
            }
        }
        this.addJava(uriPath, uri, ii);
        return true;
    }

    public Class<?> findClass(String clz) throws Throwable {
        int us = this.urls.size();
        if (us != 0) {
            this.loader = new JarLoader(this.urls.toArray(new URL[us]), this.loader);
            this.urls.clear();
        }
        return this.loader == LOADER ? Reflect.forName(clz) : Class.forName(clz, true, this.loader);
    }

    public Object findImport(String clz) {
        if (this.javaModules != null) {
            for (Object jm : this.javaModules.keySet()) {
                if (!jm.getClass().getName().equals(clz)) continue;
                return jm;
            }
        }
        return null;
    }

    public static String uri2path(String uri) {
        try {
            URI u = new URI(uri);
            TokenBuilder tb = new TokenBuilder();
            String auth = u.getAuthority();
            if (auth != null) {
                String[] comp = auth.split("\\.");
                for (int c = comp.length - 1; c >= 0; --c) {
                    tb.add(47).add(comp[c]);
                }
            } else {
                tb.add(47);
            }
            String path = u.getPath();
            if (path == null) {
                return null;
            }
            tb.add((path = path.replace('.', '/')).isEmpty() ? "/" : path);
            String pth = tb.toString();
            if (pth.endsWith("/")) {
                pth = pth + "index";
            }
            return pth;
        }
        catch (URISyntaxException ex) {
            Util.debug(ex);
            return null;
        }
    }

    private boolean addJar(IOFile file) {
        if (!file.exists()) {
            return false;
        }
        this.addURL(file);
        return true;
    }

    private boolean addModule(IOFile file, byte[] uri, QueryParser qp) throws QueryException {
        if (!file.exists()) {
            return false;
        }
        qp.module(Token.token(file.path()), uri);
        return true;
    }

    private void addJava(String path, byte[] uri, InputInfo ii) throws QueryException {
        String cp = path.replace('/', '.').substring(1);
        Class<?> clz = null;
        try {
            clz = this.findClass(cp);
        }
        catch (ClassNotFoundException ex) {
            Err.NOMODULE.thrw(ii, new Object[]{uri});
        }
        catch (Throwable th) {
            Util.debug(th);
            Err.MODINIT.thrw(ii, th);
        }
        boolean qm = clz.getSuperclass() == QueryModule.class;
        Object jm = Reflect.get(clz);
        if (jm == null) {
            Err.NOINST.thrw(ii, cp);
        }
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method m : clz.getMethods()) {
            if (qm && m.getDeclaringClass() != clz) continue;
            list.add(m);
        }
        if (this.javaModules == null) {
            this.javaModules = new HashMap();
        }
        this.javaModules.put(jm, list);
    }

    private void addRepo(byte[] name, TokenSet toLoad, TokenSet loaded, InputInfo ii, QueryParser qp) throws QueryException {
        IOFile pkgDir;
        IOFile pkgDesc;
        if (loaded.contains(name)) {
            return;
        }
        byte[] pDir = this.context.repo.pkgDict().get(name);
        if (pDir == null) {
            Err.BXRE_NOTINST.thrw(ii, new Object[]{name});
        }
        if (!((IO)(pkgDesc = new IOFile(pkgDir = this.context.repo.path(Token.string(pDir)), "expath-pkg.xml"))).exists()) {
            Util.debug("Missing package descriptor for package '%'", Token.string(name));
        }
        Package pkg = new PkgParser(this.context.repo, ii).parse(pkgDesc);
        IOFile jarDesc = new IOFile(pkgDir, PkgText.JARDESC);
        if (jarDesc.exists()) {
            this.addJar(jarDesc, pkgDir, Token.string(pkg.abbrev), ii);
        }
        if (pkg.dep.size() != 0) {
            toLoad.add(name);
        }
        for (Package.Dependency d : pkg.dep) {
            if (d.pkg == null) continue;
            byte[] depPkg = new PkgValidator(this.context.repo, ii).depPkg(d);
            if (depPkg == null) {
                Err.BXRE_NOTINST.thrw(ii, Token.string(d.pkg));
                continue;
            }
            if (toLoad.contains(depPkg)) {
                Err.CIRCMODULE.thrw(ii, new Object[0]);
            }
            this.addRepo(depPkg, toLoad, loaded, ii, qp);
        }
        for (Package.Component comp : pkg.comps) {
            String p = new IOFile(new IOFile(pkgDir, Token.string(pkg.abbrev)), Token.string(comp.file)).path();
            qp.module(Token.token(p), comp.uri);
        }
        if (toLoad.id(name) != 0) {
            toLoad.delete(name);
        }
        loaded.add(name);
    }

    private void addJar(IOFile jarDesc, IOFile pkgDir, String modDir, InputInfo ii) throws QueryException {
        JarDesc desc = new JarParser(this.context, ii).parse(jarDesc);
        for (byte[] u : desc.jars) {
            this.addURL(new IOFile(new IOFile(pkgDir, modDir), Token.string(u)));
        }
    }

    private void addURL(IOFile jar) {
        try {
            this.urls.add(new URL(jar.url()));
        }
        catch (MalformedURLException ex) {
            Util.errln(ex.getMessage(), new Object[0]);
        }
    }
}

