/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.pkg;

import java.io.IOException;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.iter.AxisIter;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.util.Err;
import org.basex.query.util.pkg.Package;
import org.basex.query.util.pkg.PkgText;
import org.basex.query.util.pkg.Repo;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public final class PkgParser {
    private final Repo repo;
    private final InputInfo info;

    public PkgParser(Repo r, InputInfo ii) {
        this.repo = r;
        this.info = ii;
    }

    public Package parse(IO io) throws QueryException {
        Package pkg = new Package();
        try {
            byte[] content = io.read();
            DBNode doc = new DBNode(new IOContent(content), this.repo.context.prop);
            ANode node = PkgParser.childElements(doc).next();
            if (!PkgParser.eqNS(PkgText.PACKAGE, node.qname())) {
                Err.BXRE_DESC.thrw(this.info, Util.info("Invalid element %", node.qname()));
            }
            this.parseAttributes(node, pkg, PkgText.PACKAGE);
            this.parseChildren(node, pkg);
            return pkg;
        }
        catch (IOException ex) {
            throw Err.BXRE_PARSE.thrw(this.info, io.name(), ex);
        }
    }

    private void parseAttributes(ANode node, Package p, byte[] root) throws QueryException {
        ANode next;
        AxisMoreIter atts = node.attributes();
        while ((next = atts.next()) != null) {
            byte[] name = next.name();
            if (Token.eq(PkgText.A_NAME, name)) {
                p.name = next.string();
                continue;
            }
            if (Token.eq(PkgText.A_ABBREV, name)) {
                p.abbrev = next.string();
                continue;
            }
            if (Token.eq(PkgText.A_VERSION, name)) {
                p.version = next.string();
                continue;
            }
            if (Token.eq(PkgText.A_SPEC, name)) {
                p.spec = next.string();
                continue;
            }
            Err.BXRE_DESC.thrw(this.info, Util.info("Invalid attribute '%'", new Object[]{name}));
        }
        if (p.name == null) {
            Err.BXRE_DESC.thrw(this.info, Util.info("'%' attribute missing in '%' element", PkgText.A_NAME, root));
        }
        if (p.version == null) {
            Err.BXRE_DESC.thrw(this.info, Util.info("'%' attribute missing in '%' element", PkgText.A_VERSION, root));
        }
        if (p.abbrev == null) {
            Err.BXRE_DESC.thrw(this.info, Util.info("'%' attribute missing in '%' element", PkgText.A_ABBREV, root));
        }
        if (p.spec == null) {
            Err.BXRE_DESC.thrw(this.info, Util.info("'%' attribute missing in '%' element", PkgText.A_SPEC, root));
        }
    }

    private void parseChildren(ANode node, Package p) throws QueryException {
        ANode next;
        AxisIter ch = PkgParser.childElements(node);
        while ((next = ch.next()) != null) {
            QNm name = next.qname();
            if (PkgParser.eqNS(PkgText.DEPEND, name)) {
                p.dep.add(this.parseDependency(next));
                continue;
            }
            if (!PkgParser.eqNS(PkgText.XQUERY, name)) continue;
            p.comps.add(this.parseComp(next));
        }
    }

    private Package.Dependency parseDependency(ANode node) throws QueryException {
        ANode next;
        AxisMoreIter atts = node.attributes();
        Package.Dependency d = new Package.Dependency();
        while ((next = atts.next()) != null) {
            byte[] name = next.name();
            if (Token.eq(PkgText.A_PACKAGE, name)) {
                d.pkg = next.string();
                continue;
            }
            if (Token.eq(PkgText.A_PROCESSOR, name)) {
                d.processor = next.string();
                continue;
            }
            if (Token.eq(PkgText.A_VERSIONS, name)) {
                d.versions = next.string();
                continue;
            }
            if (Token.eq(PkgText.A_SEMVER, name)) {
                d.semver = next.string();
                continue;
            }
            if (Token.eq(PkgText.A_SEMVER_MIN, name)) {
                d.semverMin = next.string();
                continue;
            }
            if (Token.eq(PkgText.A_SEMVER_MAX, name)) {
                d.semverMax = next.string();
                continue;
            }
            Err.BXRE_DESC.thrw(this.info, Util.info("Invalid attribute '%'", new Object[]{name}));
        }
        return d;
    }

    private Package.Component parseComp(ANode node) throws QueryException {
        ANode next;
        AxisIter ch = PkgParser.childElements(node);
        Package.Component c = new Package.Component();
        while ((next = ch.next()) != null) {
            QNm name = next.qname();
            if (PkgParser.eqNS(PkgText.A_NAMESPACE, name)) {
                c.uri = next.string();
                continue;
            }
            if (PkgParser.eqNS(PkgText.A_FILE, name)) {
                c.file = next.string();
                continue;
            }
            Err.BXRE_DESC.thrw(this.info, Util.info("Invalid element %", name));
        }
        if (c.uri == null) {
            Err.BXRE_DESC.thrw(this.info, Util.info("Component '%' not specified", new Object[]{PkgText.A_NAMESPACE}));
        }
        if (c.file == null) {
            Err.BXRE_DESC.thrw(this.info, Util.info("Component '%' not specified", new Object[]{PkgText.A_FILE}));
        }
        return c;
    }

    private static AxisIter childElements(final ANode node) {
        return new AxisIter(){
            final AxisIter ch;
            {
                this.ch = node.children();
            }

            @Override
            public ANode next() {
                ANode n;
                while ((n = this.ch.next()) != null && n.type != NodeType.ELM) {
                }
                return n;
            }
        };
    }

    private static boolean eqNS(byte[] cmp, QNm name) {
        return name.eq(new QNm(cmp, QueryText.PKGURI));
    }
}

