/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.basex.query.QueryException;
import org.basex.query.util.Err;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public abstract class ADate
extends Item {
    private static final Pattern TOSTRING1 = Pattern.compile("\\.0+(Z|-.*|\\+.*)?$");
    private static final Pattern TOSTRING2 = Pattern.compile("(\\.\\d+?)0+(Z|-.*|\\+.*)?$");
    static final String ZONE = "((\\+|-)([0-9]{2}):([0-9]{2})|Z)?";
    static final byte[] DAYS = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final Pattern DAT = Pattern.compile("(-?)([0-9]{4})-([0-9]{2})-([0-9]{2})((\\+|-)([0-9]{2}):([0-9]{2})|Z)?");
    private static final Pattern TIM = Pattern.compile("([0-9]{2}):([0-9]{2}):([0-9]{2})(\\.([0-9]+))?((\\+|-)([0-9]{2}):([0-9]{2})|Z)?");
    public static DatatypeFactory df;
    public XMLGregorianCalendar xc;

    ADate(Type typ, ADate d) {
        super(typ);
        this.xc = (XMLGregorianCalendar)d.xc.clone();
    }

    ADate(Type typ, byte[] d, String e, InputInfo ii) throws QueryException {
        super(typ);
        try {
            this.xc = df.newXMLGregorianCalendar(Token.string(d).trim());
            if (this.xc.getHour() == 24) {
                this.xc.add(df.newDuration(0L));
            }
        }
        catch (IllegalArgumentException ex) {
            throw this.dateErr(d, e, ii);
        }
    }

    final void date(byte[] d, String e, InputInfo ii) throws QueryException {
        Matcher mt = DAT.matcher(Token.string(d).trim());
        if (!mt.matches()) {
            this.dateErr(d, e, ii);
        }
        ADate.zone(mt, 5, d, ii);
    }

    final void time(byte[] d, String e, InputInfo ii) throws QueryException {
        double ms;
        Matcher mt = TIM.matcher(Token.string(d).trim());
        if (!mt.matches()) {
            this.dateErr(d, e, ii);
        }
        int h = Token.toInt(mt.group(1));
        int s = Token.toInt(mt.group(3));
        if (s > 59) {
            Err.DATERANGE.thrw(ii, this.type, d);
        }
        double d2 = ms = mt.group(4) != null ? Double.parseDouble(mt.group(4)) : 0.0;
        if (h == 24 && ms > 0.0) {
            this.dateErr(d, e, ii);
        }
        ADate.zone(mt, 6, d, ii);
    }

    static final void zone(Matcher mt, int p, byte[] val, InputInfo ii) throws QueryException {
        if (mt.group(p) == null || mt.group(p).equals("Z")) {
            return;
        }
        int th = Token.toInt(mt.group(p + 2));
        int tm = Token.toInt(mt.group(p + 3));
        if (th > 14 || tm > 59 || th == 14 && tm != 0) {
            Err.INVALIDZONE.thrw(ii, new Object[]{val});
        }
    }

    final void calc(Dur a, boolean p, InputInfo ii) throws QueryException {
        if (this.xc.getYear() + a.mon / 12 > 9999) {
            Err.DATERANGE.thrw(ii, this.type, a.string(ii));
        }
        Duration dur = a.toJava();
        this.xc.add(p ? dur : dur.negate());
        if (this.xc.getYear() == 0) {
            this.xc.setYear(p ^ dur.getSign() < 0 ? 1 : -1);
        }
    }

    @Override
    public final byte[] string(InputInfo ii) {
        String str = this.xc.toXMLFormat();
        str = TOSTRING1.matcher(str).replaceAll("$1");
        str = TOSTRING2.matcher(str).replaceAll("$1$2");
        return Token.token(str);
    }

    @Override
    public final boolean eq(InputInfo ii, Item it) throws QueryException {
        long d1 = this.days();
        ADate d = (ADate)(it.type.isDate() ? it : this.type.cast(it, null, ii));
        long d2 = d.days();
        return d1 == d2 && this.seconds().doubleValue() == d.seconds().doubleValue();
    }

    @Override
    public int diff(InputInfo ii, Item it) throws QueryException {
        ADate d;
        long d2;
        long d1 = this.days();
        if (d1 != (d2 = (d = (ADate)(it.type.isDate() ? it : this.type.cast(it, null, ii))).days())) {
            return (int)(d1 - d2);
        }
        return this.seconds().subtract(d.seconds()).signum();
    }

    @Override
    public final XMLGregorianCalendar toJava() {
        return this.xc;
    }

    final BigDecimal seconds() {
        BigDecimal bd;
        int h = this.xc.getHour() == Integer.MIN_VALUE ? 0 : this.xc.getHour();
        int m = this.xc.getMinute() == Integer.MIN_VALUE ? 0 : this.xc.getMinute();
        int s = this.xc.getSecond() == Integer.MIN_VALUE ? 0 : this.xc.getSecond();
        int z = this.xc.getTimezone();
        if (z == Integer.MIN_VALUE) {
            long ms = System.currentTimeMillis();
            z = Calendar.getInstance().getTimeZone().getOffset(ms) / 60000;
        }
        if ((bd = this.xc.getFractionalSecond()) == null) {
            bd = BigDecimal.valueOf(0L);
        }
        return bd.add(BigDecimal.valueOf(h * 3600 + m * 60 - z * 60 + s));
    }

    final long days() {
        int y = this.xc.getYear() == Integer.MIN_VALUE ? 0 : this.xc.getYear();
        int m = this.xc.getMonth() == Integer.MIN_VALUE ? 0 : this.xc.getMonth() - 1;
        int d = this.xc.getDay() == Integer.MIN_VALUE ? 0 : this.xc.getDay() - 1;
        long s = ADate.days(y, m, d);
        return y > 0 ? s : -s;
    }

    private static long dpm(int y, int m) {
        return DAYS[m] + (m == 1 ? ADate.leap(y) : 0);
    }

    private static int leap(int y) {
        return y % 4 == 0 && (y % 100 != 0 || y % 400 == 0) ? 1 : 0;
    }

    public static long days(int y, int m, int d) {
        int i;
        long n = 0L;
        int yy = Math.abs(y);
        for (i = 0; i < yy; ++i) {
            n += (long)(365 + ADate.leap(i));
        }
        for (i = 0; i < m; ++i) {
            n += ADate.dpm(y, i);
        }
        return n + (long)d;
    }

    @Override
    public final String toString() {
        return Util.info("\"%\"", new Object[]{this.string(null)});
    }

    static {
        try {
            df = DatatypeFactory.newInstance();
        }
        catch (Exception ex) {
            Util.notexpected(new Object[0]);
        }
    }
}

