/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import org.basex.query.QueryException;
import org.basex.query.util.Err;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.Base64;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public class B64
extends Bin {
    B64() {
        super(null, AtomType.B64);
    }

    public B64(byte[] d) {
        super(d, AtomType.B64);
    }

    public B64(byte[] v, InputInfo ii) throws QueryException {
        super(B64.decode(v, ii), AtomType.B64);
    }

    public B64(Bin b, InputInfo ii) throws QueryException {
        this(b.binary(ii));
    }

    @Override
    public byte[] string(InputInfo ii) throws QueryException {
        return Base64.encode(this.binary(ii));
    }

    @Override
    public boolean eq(InputInfo ii, Item it) throws QueryException {
        return Token.eq(this.binary(ii), it instanceof Bin ? ((Bin)it).binary(ii) : B64.decode(it.string(ii), ii));
    }

    private static byte[] decode(byte[] d, InputInfo ii) throws QueryException {
        try {
            return Base64.decode(d);
        }
        catch (IllegalArgumentException ex) {
            String chars = ex.getMessage().replaceAll("^.*?: |\\.$", "");
            throw Err.FUNCAST.thrw(ii, AtomType.B64, chars);
        }
    }

    @Override
    public String toString() {
        return Util.info("\"%\"", new Object[]{Base64.encode(this.data)});
    }
}

