/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.io.IOException;
import org.basex.io.IO;
import org.basex.io.in.BufferInput;
import org.basex.query.QueryException;
import org.basex.query.func.Function;
import org.basex.query.util.Err;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Item;
import org.basex.util.InputInfo;
import org.basex.util.Util;

public final class B64Stream
extends B64 {
    private final IO input;
    private final Err error;

    public B64Stream(IO in, Err err) {
        this.input = in;
        this.error = err;
    }

    @Override
    public boolean eq(InputInfo ii, Item it) throws QueryException {
        return this.type == it.type ? this.input.eq(((B64Stream)it).input) : super.eq(ii, it);
    }

    @Override
    public byte[] binary(InputInfo ii) throws QueryException {
        if (this.data == null) {
            try {
                this.data = this.input.read();
            }
            catch (IOException ex) {
                this.error.thrw(ii, ex);
            }
        }
        return this.data;
    }

    @Override
    public BufferInput input(InputInfo ii) throws QueryException {
        try {
            return new BufferInput(this.input);
        }
        catch (IOException ex) {
            throw this.error.thrw(ii, ex);
        }
    }

    @Override
    public Item materialize(InputInfo ii) throws QueryException {
        try {
            return new B64(this.input(ii).content());
        }
        catch (IOException ex) {
            throw this.error.thrw(ii, ex);
        }
    }

    @Override
    public String toString() {
        return Util.info(Function._FILE_READ_BINARY.args(this.input), new Object[0]);
    }
}

