/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class Bln
extends Item {
    public static final Bln TRUE = new Bln(true);
    public static final Bln FALSE = new Bln(false);
    private final boolean val;

    private Bln(boolean b) {
        super(AtomType.BLN);
        this.val = b;
    }

    private Bln(boolean b, double s) {
        this(b);
        this.score = s;
    }

    public static Bln get(double s) {
        return s == 0.0 ? FALSE : new Bln(true, s);
    }

    public static Bln get(boolean b) {
        return b ? TRUE : FALSE;
    }

    @Override
    public byte[] string(InputInfo ii) {
        return Token.token(this.val);
    }

    public byte[] string() {
        return Token.token(this.val);
    }

    @Override
    public boolean bool(InputInfo ii) {
        return this.val;
    }

    @Override
    public long itr(InputInfo ii) {
        return this.val ? 1L : 0L;
    }

    @Override
    public float flt(InputInfo ii) {
        return this.val ? 1.0f : 0.0f;
    }

    @Override
    public double dbl(InputInfo ii) {
        return this.val ? 1.0 : 0.0;
    }

    @Override
    public BigDecimal dec(InputInfo ii) {
        return this.val ? BigDecimal.ONE : BigDecimal.ZERO;
    }

    @Override
    public boolean eq(InputInfo ii, Item it) throws QueryException {
        return this.val == (it.type == this.type ? it.bool(ii) : Bln.parse(it.string(ii), ii));
    }

    @Override
    public int diff(InputInfo ii, Item it) throws QueryException {
        boolean n;
        boolean bl = n = it.type == this.type ? it.bool(ii) : Bln.parse(it.string(ii), ii);
        return this.val ? (!n ? 1 : 0) : (n ? -1 : 0);
    }

    @Override
    public Boolean toJava() {
        return this.val;
    }

    @Override
    public boolean sameAs(Expr cmp) {
        return cmp instanceof Bln && this.val == ((Bln)cmp).val;
    }

    public static boolean parse(byte[] str, InputInfo ii) throws QueryException {
        byte[] s = Token.trim(str);
        if (Token.eq(s, Token.TRUE) || Token.eq(s, Token.ONE)) {
            return true;
        }
        if (Token.eq(s, Token.FALSE) || Token.eq(s, Token.ZERO)) {
            return false;
        }
        throw Err.FUNCAST.thrw(ii, AtomType.BLN, str);
    }

    @Override
    public String toString() {
        return new TokenBuilder(this.val ? Token.TRUE : Token.FALSE).add("()").toString();
    }
}

