/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.VarRef;
import org.basex.query.func.DynamicFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.util.Var;
import org.basex.query.util.VarStack;
import org.basex.query.value.Value;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;

public final class FuncItem
extends FItem {
    private final Var[] vars;
    private final Expr expr;
    private final QNm name;
    private final SeqType cast;
    private final VarStack closure = new VarStack();

    public FuncItem(QNm n, Var[] arg, Expr body, FuncType t, boolean cst) {
        super(t);
        this.name = n;
        this.vars = arg;
        this.expr = body;
        this.cast = cst && t.ret != null ? t.ret : null;
    }

    public FuncItem(Var[] arg, Expr body, FuncType t, VarStack cl, boolean cst) {
        this(null, arg, body, t, cst);
        if (cl != null) {
            int i = cl.size;
            while (--i >= 0) {
                Var v = cl.vars[i];
                if (body.count(v) == 0 || this.closure.contains(v)) continue;
                this.closure.add(v.copy());
            }
        }
    }

    @Override
    public int arity() {
        return this.vars.length;
    }

    @Override
    public QNm fName() {
        return this.name;
    }

    private void bindVars(QueryContext ctx, Value[] args) throws QueryException {
        int v = this.closure.size;
        while (--v >= 0) {
            ctx.vars.add(this.closure.vars[v].copy());
        }
        v = this.vars.length;
        while (--v >= 0) {
            ctx.vars.add(this.vars[v].bind(args[v], ctx).copy());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value invValue(QueryContext ctx, InputInfo ii, Value ... args) throws QueryException {
        VarStack cs = ctx.vars.cache(args.length);
        Value cv = ctx.value;
        try {
            this.bindVars(ctx, args);
            ctx.value = null;
            Value v = ctx.value(this.expr);
            Value value = this.cast != null ? this.cast.promote(v, ctx, ii) : v;
            return value;
        }
        finally {
            ctx.value = cv;
            ctx.vars.reset(cs);
        }
    }

    @Override
    public Iter invIter(QueryContext ctx, InputInfo ii, Value ... args) throws QueryException {
        return this.invValue(ctx, ii, args).iter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Item invItem(QueryContext ctx, InputInfo ii, Value ... args) throws QueryException {
        VarStack cs = ctx.vars.cache(args.length);
        Value cv = ctx.value;
        try {
            this.bindVars(ctx, args);
            ctx.value = null;
            Item it = this.expr.item(ctx, ii);
            Item item = this.cast != null ? this.cast.cast(it, false, ctx, ii, this.expr) : it;
            return item;
        }
        finally {
            ctx.value = cv;
            ctx.vars.reset(cs);
        }
    }

    @Override
    public String toString() {
        FuncType ft = (FuncType)this.type;
        StringBuilder sb = new StringBuilder("function").append('(');
        for (Var v : this.vars) {
            sb.append(v).append(v == this.vars[this.vars.length - 1] ? "" : ", ");
        }
        return sb.append(')').append(ft.ret != null ? " as " + ft.ret : "").append(" { ").append(this.expr).append(" }").toString();
    }

    @Override
    public boolean uses(Expr.Use u) {
        return this.expr.uses(u);
    }

    @Override
    public int count(Var v) {
        return this.expr.count(v);
    }

    private static FuncItem coerce(QueryContext ctx, InputInfo ii, FuncItem fun, FuncType t) {
        Var[] vars = new Var[fun.vars.length];
        Expr[] refs = new Expr[vars.length];
        int i = vars.length;
        while (i-- > 0) {
            vars[i] = ctx.uniqueVar(ii, t.args[i]);
            refs[i] = new VarRef(ii, vars[i]);
        }
        return new FuncItem(fun.name, vars, new DynamicFunc(ii, (Expr)fun, refs), t, fun.cast != null);
    }

    @Override
    public FItem coerceTo(FuncType ft, QueryContext ctx, InputInfo ii) throws QueryException {
        if (this.vars.length != ft.args.length) {
            throw Err.cast(ii, ft, this);
        }
        return this.type.instanceOf(ft) ? this : FuncItem.coerce(ctx, ii, this, ft);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem("type", this.type), new Object[]{this.vars, this.expr});
    }
}

