/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import org.basex.query.QueryException;
import org.basex.query.util.Err;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class Hex
extends Bin {
    public Hex(byte[] b) {
        super(b, AtomType.HEX);
    }

    public Hex(byte[] v, InputInfo ii) throws QueryException {
        super(Hex.decode(Token.trim(v), ii), AtomType.HEX);
    }

    public Hex(Bin b, InputInfo ii) throws QueryException {
        this(b.binary(ii));
    }

    @Override
    public byte[] string(InputInfo ii) throws QueryException {
        return Token.hex(this.binary(ii), true);
    }

    @Override
    public boolean eq(InputInfo ii, Item it) throws QueryException {
        return Token.eq(this.binary(ii), it instanceof Bin ? ((Bin)it).binary(ii) : Hex.decode(it.string(ii), ii));
    }

    private static byte[] decode(byte[] d, InputInfo ii) throws QueryException {
        if ((d.length & 1) != 0) {
            throw Err.FUNCAST.thrw(ii, AtomType.HEX, Character.valueOf((char)d[0]));
        }
        int l = d.length >>> 1;
        byte[] v = new byte[l];
        for (int i = 0; i < l; ++i) {
            v[i] = (byte)((Hex.dec(d[i << 1], ii) << 4) + Hex.dec(d[(i << 1) + 1], ii));
        }
        return v;
    }

    private static int dec(byte b, InputInfo ii) throws QueryException {
        if (b >= 48 && b <= 57) {
            return b - 48;
        }
        if (b >= 97 && b <= 102 || b >= 65 && b <= 70) {
            return (b & 0xF) + 9;
        }
        throw Err.FUNCAST.thrw(ii, AtomType.HEX, Character.valueOf((char)b));
    }

    @Override
    public String toString() {
        return new TokenBuilder().add(34).add(Token.hex(this.data, true)).add(34).toString();
    }
}

