/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.io.IOException;
import java.math.BigDecimal;
import org.basex.data.ExprInfo;
import org.basex.io.in.ArrayInput;
import org.basex.io.in.BufferInput;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.iter.ValueIter;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Int;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public abstract class Item
extends Value {
    public static final int UNDEF = Integer.MIN_VALUE;
    public Double score;

    protected Item(Type t) {
        super(t);
    }

    @Override
    public final ValueIter iter() {
        return new ItemIter(this);
    }

    @Override
    public final Item item(QueryContext ctx, InputInfo ii) {
        return this;
    }

    @Override
    public final Item itemAt(long pos) {
        return this;
    }

    @Override
    public final Item ebv(QueryContext ctx, InputInfo ii) {
        return this;
    }

    @Override
    public final Item test(QueryContext ctx, InputInfo ii) throws QueryException {
        return this.bool(ii) ? this : null;
    }

    @Override
    public final boolean isItem() {
        return true;
    }

    public abstract byte[] string(InputInfo var1) throws QueryException;

    public boolean bool(InputInfo ii) throws QueryException {
        throw Err.CONDTYPE.thrw(ii, this.type, this);
    }

    public BigDecimal dec(InputInfo ii) throws QueryException {
        return Dec.parse(this.string(ii), ii);
    }

    public long itr(InputInfo ii) throws QueryException {
        return Int.parse(this.string(ii), ii);
    }

    public float flt(InputInfo ii) throws QueryException {
        return Flt.parse(this.string(ii), ii);
    }

    public double dbl(InputInfo ii) throws QueryException {
        return Dbl.parse(this.string(ii), ii);
    }

    public final boolean comparable(Item it) {
        Type t1 = this.type;
        Type t2 = it.type;
        return t1 == t2 || t1.isNumber() && t2.isNumber() || (t1.isUntyped() || t1.isString()) && (t2.isUntyped() || t2.isString()) || t1.isDuration() && t2.isDuration();
    }

    public abstract boolean eq(InputInfo var1, Item var2) throws QueryException;

    public final boolean equiv(InputInfo ii, Item it) throws QueryException {
        return (this == Dbl.NAN || this == Flt.NAN) && it.type.isNumber() && Double.isNaN(it.dbl(ii)) || this.comparable(it) && this.eq(ii, it);
    }

    public int diff(InputInfo ii, Item it) throws QueryException {
        throw (this == it ? Err.TYPECMP : Err.XPTYPECMP).thrw(ii, this.type, it.type);
    }

    public BufferInput input(InputInfo ii) throws QueryException {
        return new ArrayInput(this.string(ii));
    }

    @Override
    public Item materialize(InputInfo ii) throws QueryException {
        return this;
    }

    @Override
    public final SeqType type() {
        return this.type.seqType();
    }

    @Override
    public final long size() {
        return 1L;
    }

    @Override
    public final boolean iterable() {
        return true;
    }

    public double score() {
        return this.score == null ? 0.0 : this.score;
    }

    public final void score(double s) {
        if (this.score != null || s != 0.0) {
            this.score = s;
        }
    }

    public final void serialize(Serializer ser) throws IOException {
        ser.serialize(this);
    }

    final QueryException castErr(Object val, InputInfo ii) throws QueryException {
        return Err.FUNCAST.thrw(ii, this.type, val);
    }

    final QueryException dateErr(byte[] i, String ex, InputInfo ii) throws QueryException {
        throw Err.DATEFORMAT.thrw(ii, this.type, i, ex);
    }

    @Override
    public String description() {
        return ((Object)this.type).toString();
    }

    @Override
    public void plan(FElem plan) {
        try {
            this.addPlan(plan, this.planElem(QueryText.VAL, this.string(null), QueryText.TYP, this.type), new ExprInfo[0]);
        }
        catch (QueryException ex) {
            Util.notexpected(ex);
        }
    }

    @Override
    public int hash(InputInfo ii) throws QueryException {
        return Token.hash(this.string(ii));
    }

    @Override
    public final int writeTo(Item[] arr, int start) {
        arr[start] = this;
        return 1;
    }

    @Override
    public final boolean homogenous() {
        return true;
    }

    public byte[] xdmInfo() {
        return new byte[]{this.typeId()};
    }

    public byte typeId() {
        return this.type.id();
    }

    private static final class ItemIter
    extends ValueIter {
        private final Item item;
        private boolean req;

        ItemIter(Item it) {
            this.item = it;
        }

        @Override
        public Item next() {
            if (this.req) {
                return null;
            }
            this.req = true;
            return this.item;
        }

        @Override
        public long size() {
            return 1L;
        }

        @Override
        public Item get(long i) {
            return this.item;
        }

        @Override
        public boolean reset() {
            this.req = false;
            return true;
        }

        @Override
        public Value value() {
            return this.item;
        }
    }
}

