/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import javax.xml.namespace.QName;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.ByteList;

public final class QNm
extends Item {
    private byte[] uri;
    private byte[] name;
    private int pref;

    public QNm() {
        super(AtomType.QNM);
        this.name = Token.EMPTY;
    }

    public QNm(byte[] n) {
        super(AtomType.QNM);
        this.name = n;
        this.pref = Token.indexOf(n, 58);
    }

    public QNm(String n) {
        this(Token.token(n));
    }

    public QNm(byte[] n, byte[] u) {
        this(n);
        this.uri(u);
    }

    public QNm(String n, byte[] u) {
        this(Token.token(n), u);
    }

    public QNm(String n, String u) {
        this(Token.token(n), Token.token(u));
    }

    public QNm(byte[] n, QueryContext ctx) {
        this(n);
        this.uri(ctx.sc.ns.uri(this.prefix()));
    }

    public QNm(QName qn) {
        this(Token.token(qn.getPrefix().isEmpty() ? qn.getLocalPart() : qn.getPrefix() + ':' + qn.getLocalPart()), Token.token(qn.getNamespaceURI()));
    }

    public void uri(byte[] u) {
        this.uri = u == null ? null : Token.norm(u);
    }

    public byte[] uri() {
        return this.uri == null ? Token.EMPTY : this.uri;
    }

    public boolean hasURI() {
        return this.uri != null;
    }

    @Override
    public byte[] string(InputInfo ii) {
        return this.name;
    }

    public byte[] string() {
        return this.name;
    }

    @Override
    public boolean bool(InputInfo ii) throws QueryException {
        throw Err.CONDTYPE.thrw(ii, this.type, this);
    }

    @Override
    public boolean eq(InputInfo ii, Item it) {
        return this.eq((QNm)it);
    }

    public boolean eq(QNm n) {
        return n == this || Token.eq(this.local(), n.local()) && Token.eq(this.uri(), n.uri());
    }

    @Override
    public int diff(InputInfo ii, Item it) throws QueryException {
        throw Err.diff(ii, it, this);
    }

    public boolean hasPrefix() {
        return this.pref != -1;
    }

    public byte[] prefix() {
        return this.pref == -1 ? Token.EMPTY : Token.substring(this.name, 0, this.pref);
    }

    public byte[] local() {
        return this.pref == -1 ? this.name : Token.substring(this.name, this.pref + 1);
    }

    public void update(byte[] n, byte[] u) {
        this.name = n;
        this.pref = Token.indexOf(this.name, 58);
        this.uri = u;
    }

    @Override
    public QName toJava() {
        return new QName(Token.string(this.uri()), Token.string(this.local()), Token.string(this.prefix()));
    }

    public byte[] eqname() {
        return new TokenBuilder().add(123).add(this.uri()).add(125).add(this.local()).finish();
    }

    @Override
    public int hash(InputInfo ii) throws QueryException {
        return Token.hash(this.local());
    }

    @Override
    public byte[] xdmInfo() {
        return new ByteList().add(this.typeId()).add(this.uri()).add(0).toArray();
    }

    @Override
    public String toString() {
        return Util.info("\"%\"", new Object[]{this.name});
    }
}

