/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.net.URI;
import java.net.URISyntaxException;
import org.basex.query.value.item.Str;
import org.basex.query.value.type.AtomType;
import org.basex.util.Token;
import org.basex.util.Util;

public final class Uri
extends Str {
    public static final Uri EMPTY = new Uri(Token.EMPTY);

    private Uri(byte[] v) {
        super(v, AtomType.URI);
    }

    public static Uri uri(byte[] uri) {
        return Uri.uri(uri, true);
    }

    public static Uri uri(byte[] uri, boolean normalize) {
        byte[] u = normalize ? Token.norm(uri) : uri;
        return u.length == 0 ? EMPTY : new Uri(u);
    }

    public Uri resolve(Uri add) {
        if (add.val.length == 0) {
            return this;
        }
        try {
            URI base = new URI(Token.string(this.val));
            URI uri = base.resolve(Token.string(Token.uri(add.val, true)));
            return Uri.uri(Token.token(uri.toString()), false);
        }
        catch (Exception ex) {
            Util.debug(ex);
            return this;
        }
    }

    public boolean isAbsolute() {
        return Token.contains(this.val, 58);
    }

    public boolean isValid() {
        try {
            new URI(Token.string(Token.uri(this.val, true)));
            return true;
        }
        catch (URISyntaxException ex) {
            return false;
        }
    }
}

