/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import java.util.HashMap;
import org.basex.data.ExprInfo;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.iter.ValueIter;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.TrieNode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.TokenMap;

public final class Map
extends FItem {
    public static final Map EMPTY = new Map(TrieNode.EMPTY);
    static final int BITS = 5;
    private final TrieNode root;
    private Value keys;
    private Int size;

    private Map(TrieNode m) {
        super(SeqType.ANY_MAP);
        this.root = m;
    }

    @Override
    public int arity() {
        return 1;
    }

    @Override
    public QNm fName() {
        return null;
    }

    @Override
    public Value invValue(QueryContext ctx, InputInfo ii, Value ... args) throws QueryException {
        return this.get(args[0].item(ctx, ii), ii);
    }

    private Item key(Item it, InputInfo ii) throws QueryException {
        if (it == null) {
            throw Err.XPEMPTY.thrw(ii, this.description());
        }
        if (it instanceof FItem) {
            throw Err.FIATOM.thrw(ii, it.description());
        }
        if (it == Flt.NAN || it == Dbl.NAN) {
            return null;
        }
        return it.type.isUntyped() ? Str.get(it.string(ii)) : it;
    }

    public Map delete(Item key, InputInfo ii) throws QueryException {
        Item k = this.key(key, ii);
        if (k == null) {
            return this;
        }
        TrieNode del = this.root.delete(k.hash(ii), k, 0, ii);
        return del == this.root ? this : (del != null ? new Map(del) : EMPTY);
    }

    public Value get(Item key, InputInfo ii) throws QueryException {
        Item k = this.key(key, ii);
        if (k == null) {
            return Empty.SEQ;
        }
        Value val = this.root.get(k.hash(ii), k, 0, ii);
        return val == null ? Empty.SEQ : val;
    }

    public Bln contains(Item k, InputInfo ii) throws QueryException {
        Item key = this.key(k, ii);
        return Bln.get(key != null && this.root.contains(key.hash(ii), key, 0, ii));
    }

    public Map addAll(Map other, InputInfo ii) throws QueryException {
        if (other == EMPTY) {
            return this;
        }
        TrieNode upd = this.root.addAll(other.root, 0, ii);
        return upd == other.root ? other : new Map(upd);
    }

    public boolean hasType(MapType t) {
        return this.root.hasType(t.keyType == AtomType.AAT ? null : t.keyType, t.ret.eq(SeqType.ITEM_ZM) ? null : t.ret);
    }

    @Override
    public Map coerceTo(FuncType ft, QueryContext ctx, InputInfo ii) throws QueryException {
        if (!(ft instanceof MapType) || !this.hasType((MapType)ft)) {
            Err.cast(ii, ft, this);
        }
        return this;
    }

    public Map insert(Item k, Value v, InputInfo ii) throws QueryException {
        Item key = this.key(k, ii);
        if (key == null) {
            return this;
        }
        TrieNode ins = this.root.insert(key.hash(ii), key, v, 0, ii);
        return ins == this.root ? this : new Map(ins);
    }

    public Int mapSize() {
        if (this.size == null) {
            this.size = Int.get(this.root.size);
        }
        return this.size;
    }

    public Value keys() {
        if (this.keys == null) {
            ValueBuilder res = new ValueBuilder(this.root.size);
            this.root.keys(res);
            this.keys = res.value();
        }
        return this.keys;
    }

    public Str collation() {
        return Str.get(QueryText.URLCOLL);
    }

    public boolean deep(InputInfo ii, Map o) throws QueryException {
        return this.root.deep(ii, o.root);
    }

    public TokenMap tokenJavaMap(InputInfo ii) throws QueryException {
        Item k;
        TokenMap tm = new TokenMap();
        ValueIter vi = this.keys().iter();
        while ((k = vi.next()) != null) {
            Value v;
            Type kt = k.type;
            if (!kt.isString()) {
                Err.FUNCMP.thrw(ii, this.description(), AtomType.STR, kt);
            }
            if (!(v = this.get(k, ii)).isItem()) {
                Err.FUNCMP.thrw(ii, this.description(), AtomType.ITEM, v);
            }
            byte[] key = k.string(null);
            byte[] val = ((Item)v).string(ii);
            byte[] o = tm.get(key);
            if (o != null) {
                val = new TokenBuilder(o).add(44).add(val).finish();
            }
            tm.add(key, val);
        }
        return tm;
    }

    @Override
    public HashMap<Object, Object> toJava() throws QueryException {
        Item k;
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        ValueIter vi = this.keys().iter();
        while ((k = vi.next()) != null) {
            map.put(k.toJava(), this.get(k, null).toJava());
        }
        return map;
    }

    @Override
    public int hash(InputInfo ii) throws QueryException {
        return this.root.hash(ii);
    }

    @Override
    public String description() {
        return "map{...}";
    }

    @Override
    public void plan(FElem plan) {
        long s = this.mapSize().itr();
        FElem el = this.planElem(QueryText.SIZE, s);
        Value ks = this.keys();
        try {
            long max = Math.min(s, 5L);
            for (long i = 0L; i < max; ++i) {
                Item key = ks.itemAt(i);
                Value val = this.get(key, null);
                key.plan(el);
                val.plan(el);
            }
        }
        catch (QueryException ex) {
            Util.notexpected(ex);
        }
        this.addPlan(plan, el, new ExprInfo[0]);
    }

    @Override
    public String toString() {
        StringBuilder sb = this.root.toString(new StringBuilder("map{ "));
        if (this.root.size > 0) {
            sb.deleteCharAt(sb.length() - 2);
        }
        return sb.append('}').toString();
    }
}

