/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public final class IntSeq
extends Seq {
    private final long[] vals;

    private IntSeq(long[] ints, Type t) {
        super(ints.length, t);
        this.vals = ints;
    }

    @Override
    public boolean homogenous() {
        return true;
    }

    @Override
    public Item itemAt(long pos) {
        return Int.get(this.vals[(int)pos], this.type);
    }

    public long[] toJava() {
        return (long[])this.vals.clone();
    }

    @Override
    public int writeTo(Item[] arr, int start) {
        int w = Math.min(this.vals.length, arr.length - start);
        for (int i = 0; i < w; ++i) {
            arr[start + i] = this.itemAt(i);
        }
        return w;
    }

    @Override
    public Item ebv(QueryContext ctx, InputInfo ii) throws QueryException {
        throw Err.CONDTYPE.thrw(ii, this);
    }

    @Override
    public SeqType type() {
        return SeqType.get(this.type, SeqType.Occ.ONE_MORE);
    }

    public static Value get(long[] val, Type type) {
        return val.length == 0 ? Empty.SEQ : (val.length == 1 ? Int.get(val[0], type) : new IntSeq(val, type));
    }

    public static Value get(Expr[] expr, long size, Type type) throws QueryException {
        long[] tmp = new long[(int)size];
        int t = 0;
        for (Expr e : expr) {
            int v;
            long vs;
            Value val;
            if (e instanceof Item) {
                tmp[t++] = ((Item)e).itr(null);
                continue;
            }
            if (e instanceof IntSeq) {
                val = (IntSeq)e;
                vs = ((Seq)val).size();
                v = 0;
                while ((long)v < vs) {
                    tmp[t++] = ((IntSeq)val).vals[v];
                    ++v;
                }
                continue;
            }
            val = (Value)e;
            vs = val.size();
            v = 0;
            while ((long)v < vs) {
                tmp[t++] = val.itemAt(v).itr(null);
                ++v;
            }
        }
        return IntSeq.get(tmp, type);
    }
}

