/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import org.basex.data.ExprInfo;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.iter.ValueIter;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.ItemSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public abstract class Seq
extends Value {
    final long size;

    Seq(long s) {
        this(s, AtomType.ITEM);
    }

    Seq(long s, Type t) {
        super(t);
        this.size = s;
    }

    public static Value get(Item[] v, int s) {
        return Seq.get(v, s, null);
    }

    public static Value get(Item[] v, int s, Type t) {
        return s == 0 ? Empty.SEQ : (s == 1 ? v[0] : new ItemSeq(v, s, t));
    }

    @Override
    public Object toJava() throws QueryException {
        Object[] obj = new Object[(int)this.size];
        int s = 0;
        while ((long)s < this.size) {
            obj[s] = this.itemAt(s).toJava();
            ++s;
        }
        return obj;
    }

    @Override
    public final long size() {
        return this.size;
    }

    @Override
    public final Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        throw Err.XPSEQ.thrw(ii, this);
    }

    @Override
    public final Item test(QueryContext ctx, InputInfo ii) throws QueryException {
        return this.ebv(ctx, ii);
    }

    @Override
    public final ValueIter iter() {
        return new ValueIter(){
            int c;

            @Override
            public Item get(long i) {
                return Seq.this.itemAt(i);
            }

            @Override
            public Item next() {
                return (long)this.c < Seq.this.size ? Seq.this.itemAt(this.c++) : null;
            }

            @Override
            public boolean reset() {
                this.c = 0;
                return true;
            }

            @Override
            public long size() {
                return Seq.this.size;
            }

            @Override
            public Value value() {
                return Seq.this;
            }
        };
    }

    @Override
    public final int hash(InputInfo ii) throws QueryException {
        int h = 1;
        long v = Math.min(this.size, 5L);
        while (--v >= 0L) {
            h = 31 * h + this.itemAt(v).hash(ii);
        }
        return h;
    }

    @Override
    public void plan(FElem plan) {
        FElem el = this.planElem(QueryText.SIZE, this.size);
        this.addPlan(plan, el, new ExprInfo[0]);
        int v = 0;
        while ((long)v != Math.min(this.size, 5L)) {
            this.itemAt(v).plan(el);
            ++v;
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        int i = 0;
        while ((long)i < this.size) {
            sb.append(i != 0 ? ", " : "").append(this.itemAt(i));
            if (sb.length() > 32 && (long)(i + 1) != this.size) {
                sb.append(", ...");
                break;
            }
            ++i;
        }
        return sb.append(")").toString();
    }
}

