/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import java.util.Arrays;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.func.UserFunc;
import org.basex.query.util.Err;
import org.basex.query.util.Var;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public class FuncType
implements Type {
    public static final FuncType ANY_FUN = new FuncType(null, null);
    public final SeqType[] args;
    public final SeqType ret;
    private SeqType seq;

    FuncType(SeqType[] arg, SeqType rt) {
        this.args = arg;
        this.ret = rt;
    }

    @Override
    public final boolean isNode() {
        return false;
    }

    @Override
    public final boolean isNumber() {
        return false;
    }

    @Override
    public final SeqType seqType() {
        if (this.seq == null) {
            this.seq = new SeqType(this);
        }
        return this.seq;
    }

    @Override
    public final boolean isString() {
        return false;
    }

    @Override
    public final boolean isUntyped() {
        return false;
    }

    @Override
    public final boolean isFunction() {
        return true;
    }

    @Override
    public byte[] string() {
        return Token.token("function");
    }

    @Override
    public FItem cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
        if (!it.type.isFunction()) {
            throw Err.cast(ii, this, it);
        }
        FItem f = (FItem)it;
        return this == ANY_FUN ? f : f.coerceTo(this, ctx, ii);
    }

    @Override
    public final Item cast(Object o, InputInfo ii) {
        throw Util.notexpected(o);
    }

    @Override
    public final Item castString(String s, InputInfo ii) {
        throw Util.notexpected(s);
    }

    @Override
    public final boolean instanceOf(Type t) {
        if (!(t instanceof FuncType)) {
            return t == AtomType.ITEM;
        }
        FuncType ft = (FuncType)t;
        if (this == ft || ft == ANY_FUN) {
            return true;
        }
        if (this == ANY_FUN || this.args.length != ft.args.length || !this.ret.instance(ft.ret)) {
            return false;
        }
        for (int a = 0; a < this.args.length; ++a) {
            if (ft.args[a].instance(this.args[a])) continue;
            return false;
        }
        return true;
    }

    public static FuncType get(SeqType ret, SeqType ... args) {
        return args == null || ret == null ? ANY_FUN : new FuncType(args, ret);
    }

    public static Type find(QNm type) {
        if (type.uri().length == 0) {
            byte[] ln = type.local();
            if (Token.eq(ln, Token.token("function"))) {
                return ANY_FUN;
            }
            if (Token.eq(ln, QueryText.MAP)) {
                return SeqType.ANY_MAP;
            }
        }
        return null;
    }

    public static FuncType arity(int a) {
        Object[] args = new SeqType[a];
        Arrays.fill(args, SeqType.ITEM_ZM);
        return FuncType.get(SeqType.ITEM_ZM, (SeqType[])args);
    }

    public static FuncType get(UserFunc f) {
        SeqType[] at = new SeqType[f.args.length];
        for (int a = 0; a < at.length; ++a) {
            at[a] = f.args[a] == null || f.args[a].type == null ? SeqType.ITEM_ZM : f.args[a].type;
        }
        return new FuncType(at, f.ret == null ? SeqType.ITEM_ZM : f.ret);
    }

    public final Var[] type(Var[] vars) {
        if (this != ANY_FUN) {
            for (int v = 0; v < vars.length; ++v) {
                if (vars[v] == null || this.args[v] == SeqType.ITEM_ZM) continue;
                vars[v].type = this.args[v];
            }
        }
        return vars;
    }

    @Override
    public boolean isDuration() {
        return false;
    }

    @Override
    public boolean isDate() {
        return false;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public byte id() {
        return 7;
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder("function").add(40);
        if (this == ANY_FUN) {
            tb.add(42).add(41);
        } else {
            tb.addSep(this.args, ", ").add(") as ").add(this.ret.toString());
        }
        return tb.toString();
    }
}

