/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.api.dom.BXAttr;
import org.basex.api.dom.BXComm;
import org.basex.api.dom.BXDoc;
import org.basex.api.dom.BXElem;
import org.basex.api.dom.BXPI;
import org.basex.api.dom.BXText;
import org.basex.build.MemBuilder;
import org.basex.build.xml.DOMWrapper;
import org.basex.core.Prop;
import org.basex.io.IOContent;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FAttr;
import org.basex.query.value.node.FComm;
import org.basex.query.value.node.FDoc;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FPI;
import org.basex.query.value.node.FTxt;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.TokenMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public enum NodeType implements Type
{
    NOD("node", AtomType.ITEM, 8),
    TXT("text", NOD, 9){

        @Override
        public ANode cast(Object o, InputInfo ii) {
            if (o instanceof BXText) {
                return ((BXText)o).getNod();
            }
            if (o instanceof Text) {
                return new FTxt((Text)o);
            }
            return new FTxt(Token.token(o.toString()));
        }
    }
    ,
    PI("processing-instruction", NOD, 10){

        @Override
        public ANode cast(Object o, InputInfo ii) throws QueryException {
            if (o instanceof BXPI) {
                return ((BXPI)o).getNod();
            }
            if (o instanceof ProcessingInstruction) {
                return new FPI((ProcessingInstruction)o);
            }
            Matcher m = Pattern.compile("<\\?(.*?) (.*)\\?>").matcher(o.toString());
            if (m.find()) {
                return new FPI(new QNm(m.group(1)), Token.token(m.group(2)));
            }
            throw Err.NODEERR.thrw(ii, this, o);
        }
    }
    ,
    ELM("element", NOD, 11){

        @Override
        public ANode cast(Object o, InputInfo ii) throws QueryException {
            if (o instanceof BXElem) {
                return ((BXElem)o).getNod();
            }
            if (o instanceof Element) {
                return new FElem((Element)o, null, new TokenMap());
            }
            try {
                DBNode db = new DBNode(new IOContent(o.toString()), new Prop());
                return db.children().next();
            }
            catch (IOException ex) {
                Err.NODEERR.thrw(ii, this, ex);
                return null;
            }
        }
    }
    ,
    DOC("document-node", NOD, 12){

        @Override
        public ANode cast(Object o, InputInfo ii) throws QueryException {
            if (o instanceof BXDoc) {
                return ((BXDoc)o).getNod();
            }
            try {
                if (o instanceof Document) {
                    DOMWrapper p = new DOMWrapper((Document)o, "", new Prop());
                    return new DBNode(MemBuilder.build(p));
                }
                if (o instanceof DocumentFragment) {
                    DocumentFragment df;
                    String bu = (df = (DocumentFragment)o).getBaseURI();
                    return new FDoc(df, bu != null ? Token.token(bu) : Token.EMPTY);
                }
                String c = o.toString();
                if (c.startsWith("<")) {
                    return new DBNode(new IOContent(c), new Prop());
                }
                return new FDoc(Token.EMPTY).add(new FTxt(Token.token(c)));
            }
            catch (IOException ex) {
                throw Err.NODEERR.thrw(ii, this, ex);
            }
        }
    }
    ,
    DEL("document-node(element())", NOD, 13){

        @Override
        public Item cast(Object o, InputInfo ii) throws QueryException {
            return DOC.cast(o, ii);
        }
    }
    ,
    ATT("attribute", NOD, 14){

        @Override
        public ANode cast(Object o, InputInfo ii) throws QueryException {
            if (o instanceof BXAttr) {
                return ((BXAttr)o).getNod();
            }
            if (o instanceof Attr) {
                return new FAttr((Attr)o);
            }
            Matcher m = Pattern.compile(" (.*?)=\"(.*)\"").matcher(o.toString());
            if (m.find()) {
                return new FAttr(Token.token(m.group(1)), Token.token(m.group(2)));
            }
            throw Err.NODEERR.thrw(ii, this, o);
        }
    }
    ,
    COM("comment", NOD, 15){

        @Override
        public ANode cast(Object o, InputInfo ii) throws QueryException {
            if (o instanceof BXComm) {
                return ((BXComm)o).getNod();
            }
            if (o instanceof Comment) {
                return new FComm((Comment)o);
            }
            Matcher m = Pattern.compile("<!--(.*?)-->").matcher(o.toString());
            if (m.find()) {
                return new FComm(Token.token(m.group(1)));
            }
            throw Err.NODEERR.thrw(ii, this, o);
        }
    }
    ,
    NSP("namespace-node", NOD, 16),
    SCE("schema-element", NOD, 17),
    SCA("schema-attribute", NOD, 18);

    private final byte[] string;
    private final Type par;
    private final byte id;
    private SeqType seq;

    private NodeType(String nm, Type pr, int i) {
        this.string = Token.token(nm);
        this.par = pr;
        this.id = (byte)i;
    }

    @Override
    public final boolean isNode() {
        return true;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isUntyped() {
        return true;
    }

    @Override
    public boolean isDuration() {
        return false;
    }

    @Override
    public boolean isDate() {
        return false;
    }

    @Override
    public final boolean isFunction() {
        return false;
    }

    @Override
    public final boolean isMap() {
        return false;
    }

    @Override
    public Item cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
        return it.type != this ? this.error(it, ii) : it;
    }

    @Override
    public Item cast(Object o, InputInfo ii) throws QueryException {
        Util.notexpected(o);
        return null;
    }

    @Override
    public Item castString(String o, InputInfo ii) throws QueryException {
        return this.cast(o, ii);
    }

    @Override
    public SeqType seqType() {
        if (this.seq == null) {
            this.seq = new SeqType(this);
        }
        return this.seq;
    }

    @Override
    public final boolean instanceOf(Type t) {
        return this == t || this.par != null && this.par.instanceOf(t);
    }

    @Override
    public byte id() {
        return this.id;
    }

    @Override
    public byte[] string() {
        return this.string;
    }

    @Override
    public String toString() {
        return new TokenBuilder(this.string).add("()").toString();
    }

    Item error(Item it, InputInfo ii) throws QueryException {
        Err.cast(ii, this, it);
        return null;
    }

    public static NodeType find(QNm type) {
        if (type.uri().length == 0) {
            byte[] ln = type.local();
            for (NodeType t : NodeType.values()) {
                if (!Token.eq(ln, t.string)) continue;
                return t;
            }
        }
        return null;
    }
}

