/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.path.Test;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.Map;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public final class SeqType {
    public static final SeqType EMP = new SeqType(AtomType.ITEM, Occ.ZERO);
    public static final SeqType ITEM = AtomType.ITEM.seqType();
    public static final SeqType ITEM_ZO = new SeqType(AtomType.ITEM, Occ.ZERO_ONE);
    public static final SeqType ITEM_ZM = new SeqType(AtomType.ITEM, Occ.ZERO_MORE);
    public static final SeqType ITEM_OM = new SeqType(AtomType.ITEM, Occ.ONE_MORE);
    public static final SeqType AAT = AtomType.AAT.seqType();
    public static final SeqType AAT_ZO = new SeqType(AtomType.AAT, Occ.ZERO_ONE);
    public static final SeqType AAT_ZM = new SeqType(AtomType.AAT, Occ.ZERO_MORE);
    public static final SeqType BLN = AtomType.BLN.seqType();
    public static final SeqType BLN_ZO = new SeqType(AtomType.BLN, Occ.ZERO_ONE);
    public static final SeqType DBL = AtomType.DBL.seqType();
    public static final SeqType DBL_ZM = new SeqType(AtomType.DBL, Occ.ZERO_MORE);
    public static final SeqType DBL_ZO = new SeqType(AtomType.DBL, Occ.ZERO_ONE);
    public static final SeqType DEC_ZO = new SeqType(AtomType.DEC, Occ.ZERO_ONE);
    public static final SeqType ITR = AtomType.ITR.seqType();
    public static final SeqType ITR_ZO = new SeqType(AtomType.ITR, Occ.ZERO_ONE);
    public static final SeqType ITR_ZM = new SeqType(AtomType.ITR, Occ.ZERO_MORE);
    public static final SeqType ITR_OM = new SeqType(AtomType.ITR, Occ.ONE_MORE);
    public static final SeqType NOD = NodeType.NOD.seqType();
    public static final SeqType NOD_ZO = new SeqType(NodeType.NOD, Occ.ZERO_ONE);
    public static final SeqType NOD_ZM = new SeqType(NodeType.NOD, Occ.ZERO_MORE);
    public static final SeqType QNM = AtomType.QNM.seqType();
    public static final SeqType QNM_ZO = new SeqType(AtomType.QNM, Occ.ZERO_ONE);
    public static final SeqType URI = AtomType.URI.seqType();
    public static final SeqType URI_ZO = new SeqType(AtomType.URI, Occ.ZERO_ONE);
    public static final SeqType URI_ZM = new SeqType(AtomType.URI, Occ.ZERO_MORE);
    public static final SeqType STR = AtomType.STR.seqType();
    public static final SeqType STR_ZO = new SeqType(AtomType.STR, Occ.ZERO_ONE);
    public static final SeqType STR_ZM = new SeqType(AtomType.STR, Occ.ZERO_MORE);
    public static final SeqType NCN_ZO = new SeqType(AtomType.NCN, Occ.ZERO_ONE);
    public static final SeqType DAT = AtomType.DAT.seqType();
    public static final SeqType DAT_ZO = new SeqType(AtomType.DAT, Occ.ZERO_ONE);
    public static final SeqType DTD = AtomType.DTD.seqType();
    public static final SeqType DTD_ZO = new SeqType(AtomType.DTD, Occ.ZERO_ONE);
    public static final SeqType DTM = AtomType.DTM.seqType();
    public static final SeqType DTM_ZO = new SeqType(AtomType.DTM, Occ.ZERO_ONE);
    public static final SeqType TIM = AtomType.TIM.seqType();
    public static final SeqType TIM_ZO = new SeqType(AtomType.TIM, Occ.ZERO_ONE);
    public static final SeqType DUR_ZO = new SeqType(AtomType.DUR, Occ.ZERO_ONE);
    public static final SeqType FUN_O = FuncType.ANY_FUN.seqType();
    public static final SeqType BYT_ZM = new SeqType(AtomType.BYT, Occ.ZERO_MORE);
    public static final SeqType ATT = NodeType.ATT.seqType();
    public static final SeqType COM = NodeType.COM.seqType();
    public static final SeqType DOC_O = NodeType.DOC.seqType();
    public static final SeqType DOC_ZO = new SeqType(NodeType.DOC, Occ.ZERO_ONE);
    public static final SeqType DOC_OM = new SeqType(NodeType.DOC, Occ.ONE_MORE);
    public static final SeqType DOC_ZM = new SeqType(NodeType.DOC, Occ.ZERO_MORE);
    public static final SeqType ELM = NodeType.ELM.seqType();
    public static final SeqType ELM_ZM = new SeqType(NodeType.ELM, Occ.ZERO_MORE);
    public static final SeqType NSP = NodeType.NSP.seqType();
    public static final SeqType PI = NodeType.PI.seqType();
    public static final SeqType TXT_ZO = new SeqType(NodeType.TXT, Occ.ZERO_ONE);
    public static final MapType ANY_MAP = new MapType(AtomType.AAT, ITEM_ZM);
    public static final SeqType MAP_ZM = new SeqType(ANY_MAP, Occ.ZERO_MORE);
    public static final SeqType MAP_O = new SeqType(ANY_MAP);
    public static final SeqType HEX = AtomType.HEX.seqType();
    public static final SeqType B64 = AtomType.B64.seqType();
    public static final SeqType B64_ZM = new SeqType(AtomType.B64, Occ.ZERO_MORE);
    public static final SeqType BIN = AtomType.BIN.seqType();
    public static final SeqType BIN_ZM = new SeqType(AtomType.BIN, Occ.ZERO_MORE);
    public final Type type;
    public final Occ occ;
    private final Test kind;

    private SeqType(Type t, Occ o) {
        this(t, o, null);
    }

    SeqType(Type t) {
        this(t, Occ.ONE);
    }

    private SeqType(Type t, Occ o, Test k) {
        this.type = t;
        this.occ = o;
        this.kind = k;
    }

    public static SeqType get(Type t, Occ o) {
        return o == Occ.ONE ? t.seqType() : new SeqType(t, o);
    }

    public static SeqType get(Type t, long o) {
        return SeqType.get(t, o == 0L ? Occ.ZERO : (o == 1L ? Occ.ONE : (o > 1L ? Occ.ONE_MORE : Occ.ZERO_MORE)));
    }

    public static SeqType get(Type t, Occ o, Test k) {
        return new SeqType(t, o, k);
    }

    public boolean instance(Value val) {
        long size = val.size();
        if (!this.occ.check(size)) {
            return false;
        }
        if (size == 0L) {
            return true;
        }
        MapType mt = this.type.isMap() ? (MapType)this.type : null;
        for (long i = 0L; i < size; ++i) {
            Item it = val.itemAt(i);
            Type ip = it.type;
            if (mt == null ? !ip.instanceOf(this.type) || !this.checkKind(it) : !ip.isMap() || !((Map)it).hasType(mt)) {
                return false;
            }
            if (i == 0L && val.homogenous()) break;
        }
        return true;
    }

    public Item cast(Item it, boolean cast, QueryContext ctx, InputInfo ii, Expr e) throws QueryException {
        Item i;
        if (it == null) {
            if (this.occ == Occ.ONE) {
                Err.XPEMPTY.thrw(ii, e.description());
            }
            return null;
        }
        boolean correct = cast ? it.type == this.type : this.instance(it, ii);
        Item item = i = correct ? it : this.type.cast(it, ctx, ii);
        if (!this.checkKind(i)) {
            Err.cast(ii, this.type, i);
        }
        return i;
    }

    public Value promote(Value val, QueryContext ctx, InputInfo ii) throws QueryException {
        long size = val.size();
        if (!this.occ.check(size)) {
            Err.promote(ii, this, val);
        }
        if (size == 0L) {
            return val;
        }
        Item f = val.itemAt(0L);
        if (size == 1L) {
            Item it;
            Item item = it = this.instance(f, ii) ? f : this.type.cast(f, ctx, ii);
            if (!this.checkKind(it)) {
                Err.promote(ii, this, val);
            }
            return it;
        }
        if (val.homogenous() && this.instance(f, ii) && this.checkKind(f)) {
            return val;
        }
        ValueBuilder vb = new ValueBuilder((int)size);
        for (long i = 0L; i < size; ++i) {
            Item n = val.itemAt(i);
            if (!this.instance(n, ii)) {
                n = this.type.cast(n, ctx, ii);
            }
            if (!this.checkKind(n)) {
                Err.promote(ii, this, n);
            }
            vb.add(n);
        }
        return vb.value();
    }

    private boolean instance(Item it, InputInfo ii) throws QueryException {
        Type ip = it.type;
        boolean ins = ip.instanceOf(this.type);
        if (!(ins || ip.isUntyped() || ip.isFunction() || ip == AtomType.FLT && this.type == AtomType.DBL || ip == AtomType.URI && this.type == AtomType.STR || (this.type == AtomType.FLT || this.type == AtomType.DBL) && ip.instanceOf(AtomType.DEC))) {
            Err.promote(ii, this, it);
        }
        return ins;
    }

    public SeqType intersect(SeqType t) {
        Type tp;
        Type type = tp = this.type == t.type ? this.type : AtomType.ITEM;
        Occ oc = this.occ == t.occ ? this.occ : (this.zeroOrOne() && t.zeroOrOne() ? Occ.ZERO_ONE : Occ.ZERO_MORE);
        return new SeqType(tp, oc);
    }

    public long occ() {
        return this.occ == Occ.ZERO ? 0L : (this.occ == Occ.ONE ? 1L : -1L);
    }

    public boolean zeroOrOne() {
        return this.occ.max <= 1;
    }

    public boolean one() {
        return this.occ == Occ.ONE;
    }

    public boolean mayBeZero() {
        return this.occ.min == 0;
    }

    public boolean mayBeNumber() {
        return this.type.isNumber() || this.type == AtomType.ITEM;
    }

    private boolean checkKind(Item it) {
        return this.kind == null || this.kind.eq(it);
    }

    public boolean eq(SeqType t) {
        return this.type == t.type && this.occ == t.occ;
    }

    public boolean instance(SeqType t) {
        return this.type.instanceOf(t.type) && this.occ.instance(t.occ);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.occ == Occ.ZERO ? "empty-sequence()" : this.type);
        if (this.kind != null) {
            sb.deleteCharAt(sb.length() - 1).append(this.kind).append(')');
        }
        return sb.append((Object)this.occ).toString();
    }

    public static enum Occ {
        ZERO(0, 0, ""),
        ZERO_ONE(0, 1, "?"),
        ONE(1, 1, ""),
        ONE_MORE(1, Integer.MAX_VALUE, "+"),
        ZERO_MORE(0, Integer.MAX_VALUE, "*");

        private final String str;
        public final int min;
        public final int max;

        private Occ(int mn, int mx, String s) {
            this.min = mn;
            this.max = mx;
            this.str = s;
        }

        public boolean instance(Occ o) {
            return this.min >= o.min && this.max <= o.max;
        }

        public boolean check(long c) {
            return (long)this.min <= c && c <= (long)this.max;
        }

        public String toString() {
            return this.str;
        }
    }
}

