/*
 * Decompiled with CFR 0.152.
 */
package org.basex.server;

import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Timer;
import org.basex.BaseXServer;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.MainProp;
import org.basex.core.Text;
import org.basex.core.cmd.Add;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Exit;
import org.basex.core.cmd.Replace;
import org.basex.core.cmd.Store;
import org.basex.core.parse.CommandParser;
import org.basex.io.in.BufferInput;
import org.basex.io.in.DecodingInput;
import org.basex.io.out.EncodingOutput;
import org.basex.io.out.PrintOutput;
import org.basex.query.QueryException;
import org.basex.server.ClientDelayer;
import org.basex.server.Log;
import org.basex.server.QueryListener;
import org.basex.server.ServerCmd;
import org.basex.server.Sessions;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.ByteList;

public final class ClientListener
extends Thread {
    public final Timer auth = new Timer();
    public long last;
    final Log log;
    private final HashMap<String, QueryListener> queries = new HashMap();
    private final Performance perf = new Performance();
    private final Context context;
    private final BaseXServer server;
    private final Socket socket;
    private Socket esocket;
    private PrintOutput eout;
    private boolean events;
    private BufferInput in;
    private PrintOutput out;
    private Command command;
    private int id;
    private boolean running;

    public ClientListener(Socket s, Context c, Log l, BaseXServer srv) {
        this.context = new Context(c, this);
        this.socket = s;
        this.log = l;
        this.server = srv;
        this.last = System.currentTimeMillis();
    }

    @Override
    public void run() {
        if (!this.authenticate()) {
            return;
        }
        ServerCmd sc = null;
        Object cmd = null;
        try {
            while (this.running) {
                String info;
                boolean ok;
                block26: {
                    this.command = null;
                    try {
                        int b = this.in.read();
                        if (b == -1) {
                            this.quit();
                            break;
                        }
                        this.last = System.currentTimeMillis();
                        this.perf.time();
                        sc = ServerCmd.get(b);
                        cmd = null;
                        if (sc == ServerCmd.CREATE) {
                            this.create();
                        } else if (sc == ServerCmd.ADD) {
                            this.add();
                        } else if (sc == ServerCmd.WATCH) {
                            this.watch();
                        } else if (sc == ServerCmd.UNWATCH) {
                            this.unwatch();
                        } else if (sc == ServerCmd.REPLACE) {
                            this.replace();
                        } else if (sc == ServerCmd.STORE) {
                            this.store();
                        } else if (sc != ServerCmd.COMMAND) {
                            this.query(sc);
                        } else {
                            cmd = new ByteList().add(b).add(this.in.readBytes()).toString();
                        }
                    }
                    catch (IOException ex) {
                        this.quit();
                        break;
                    }
                    if (sc != ServerCmd.COMMAND) continue;
                    try {
                        this.command = new CommandParser((String)cmd, this.context).parseSingle();
                    }
                    catch (QueryException ex) {
                        String msg = ex.getMessage();
                        this.log.write(this, cmd, Text.ERROR_C + msg);
                        this.out.write(0);
                        this.out.writeString(msg);
                        this.send(false);
                        continue;
                    }
                    this.log.write(this, this.command.toString().replace('\r', ' ').replace('\n', ' '));
                    ok = true;
                    try {
                        this.command.execute(this.context, new EncodingOutput(this.out));
                        info = this.command.info();
                    }
                    catch (BaseXException ex) {
                        ok = false;
                        info = ex.getMessage();
                        if (!info.startsWith(Text.INTERRUPTED)) break block26;
                        info = Text.TIMEOUT_EXCEEDED;
                    }
                }
                this.out.write(0);
                this.info(info, ok);
                if (!(this.command instanceof Exit)) continue;
                this.command = null;
                this.quit();
            }
        }
        catch (IOException ex) {
            this.log.write(this, sc == ServerCmd.COMMAND ? cmd : sc, Text.ERROR_C + ex.getMessage());
            Util.debug(ex);
            this.command = null;
            this.quit();
        }
        this.command = null;
    }

    private boolean authenticate() {
        block5: {
            try {
                String ts = Long.toString(System.nanoTime());
                byte[] address = this.socket.getInetAddress().getAddress();
                this.out = PrintOutput.get(this.socket.getOutputStream());
                this.out.print(ts);
                this.send(true);
                this.in = new BufferInput(this.socket.getInputStream());
                String us = this.in.readString();
                String pw = this.in.readString();
                this.context.user = this.context.users.get(us);
                boolean bl = this.running = this.context.user != null && Token.md5(this.context.user.password + ts).equals(pw);
                if (this.running) {
                    this.log.write(this, "LOGIN " + this.context.user.name, "OK");
                    this.send(true);
                    this.server.unblock(address);
                    this.context.add(this);
                } else {
                    if (!us.isEmpty()) {
                        this.log.write(this, Text.ACCESS_DENIED + ": " + us);
                    }
                    new ClientDelayer(this.server.block(address), this, this.server).start();
                }
            }
            catch (IOException ex) {
                if (!this.running) break block5;
                Util.stack(ex);
                this.log.write(ex.getMessage());
                this.running = false;
            }
        }
        this.server.remove(this);
        return this.running;
    }

    public synchronized void quitAuth() {
        try {
            this.socket.close();
            this.log.write(this, Text.ERROR_C + Text.TIMEOUT_EXCEEDED);
        }
        catch (Throwable ex) {
            this.log.write(this, ex.getMessage());
        }
    }

    public synchronized void quit() {
        if (!this.running) {
            return;
        }
        this.running = false;
        if (this.log != null) {
            this.log.write(this, "LOGOUT " + (null != this.context.user ? this.context.user.name : ""), "OK");
        }
        if (this.command != null) {
            this.command.stop();
            do {
                Performance.sleep(50L);
            } while (this.command != null);
        }
        this.context.delete(this);
        try {
            new Close().run(this.context);
            this.socket.close();
            if (this.events) {
                this.esocket.close();
                for (Sessions s : this.context.events.values()) {
                    s.remove(this);
                }
            }
        }
        catch (Throwable ex) {
            if (this.log != null) {
                this.log.write(this, ex.getMessage());
            }
            Util.stack(ex);
        }
    }

    public Context context() {
        return this.context;
    }

    public synchronized void register(Socket s) throws IOException {
        this.esocket = s;
        this.eout = PrintOutput.get(s.getOutputStream());
        this.eout.write(0);
        this.eout.flush();
    }

    public synchronized void notify(byte[] name, byte[] msg) throws IOException {
        this.last = System.currentTimeMillis();
        this.eout.print(name);
        this.eout.write(0);
        this.eout.print(msg);
        this.eout.write(0);
        this.eout.flush();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        sb.append(this.socket.getInetAddress().getHostAddress());
        sb.append(":").append(this.socket.getPort()).append(']');
        if (this.context.data() != null) {
            sb.append(": ").append(this.context.data().meta.name);
        }
        return sb.toString();
    }

    private void error(String info) throws IOException {
        this.info(info, false);
    }

    private void success(String info) throws IOException {
        this.info(info, true);
    }

    private void info(String info, boolean ok) throws IOException {
        this.log.write(this, ok ? "OK" : Text.ERROR_C + info, this.perf);
        this.out.writeString(info);
        this.send(ok);
    }

    private void create() throws IOException {
        this.execute(new CreateDB(this.in.readString()));
    }

    private void add() throws IOException {
        this.execute(new Add(this.in.readString()));
    }

    private void replace() throws IOException {
        this.execute(new Replace(this.in.readString()));
    }

    private void store() throws IOException {
        this.execute(new Store(this.in.readString()));
    }

    private void execute(Command cmd) throws IOException {
        this.log.write(this, cmd + " [...]");
        DecodingInput di = new DecodingInput(this.in);
        try {
            cmd.setInput(di);
            cmd.execute(this.context);
            this.success(cmd.info());
        }
        catch (BaseXException ex) {
            di.flush();
            this.error(ex.getMessage());
        }
    }

    private void watch() throws IOException {
        String message;
        String name;
        Sessions s;
        boolean ok;
        this.server.initEvents();
        if (!this.events) {
            this.out.writeString(Integer.toString(this.context.mprop.num(MainProp.EVENTPORT)));
            this.out.writeString(Long.toString(this.getId()));
            this.out.flush();
            this.events = true;
        }
        boolean bl = ok = (s = (Sessions)this.context.events.get(name = this.in.readString())) != null && !s.contains(this);
        if (ok) {
            s.add(this);
            message = Text.WATCHING_EVENT_X;
        } else {
            message = s == null ? Text.EVENT_UNKNOWN_X : Text.EVENT_WATCHED_X;
        }
        this.info(Util.info(message, name), ok);
    }

    private void unwatch() throws IOException {
        String message;
        boolean ok;
        String name = this.in.readString();
        Sessions s = (Sessions)this.context.events.get(name);
        boolean bl = ok = s != null && s.contains(this);
        if (ok) {
            s.remove(this);
            message = Text.UNWATCHING_EVENT_X;
        } else {
            message = s == null ? Text.EVENT_UNKNOWN_X : Text.EVENT_NOT_WATCHED_X;
        }
        this.info(Util.info(message, name), ok);
        this.out.flush();
    }

    private void query(ServerCmd sc) throws IOException {
        String arg = this.in.readString();
        String err = null;
        try {
            if (sc == ServerCmd.QUERY) {
                String query = arg;
                QueryListener qp = new QueryListener(query, this.context);
                arg = Integer.toString(this.id++);
                this.queries.put(arg, qp);
                this.out.writeString(arg);
                this.log.write(this, (Object)((Object)sc) + "(" + arg + ')', query, "OK", this.perf);
            } else {
                QueryListener qp = this.queries.get(arg);
                if (qp == null) {
                    if (sc != ServerCmd.CLOSE) {
                        throw new IOException("Unknown Query ID: " + arg);
                    }
                } else if (sc == ServerCmd.BIND) {
                    String key = this.in.readString();
                    String val = this.in.readString();
                    String typ = this.in.readString();
                    qp.bind(key, val, typ);
                    this.log.write(this, (Object)((Object)sc) + "(" + arg + ')', key, val, typ, "OK", this.perf);
                } else if (sc == ServerCmd.CONTEXT) {
                    String val = this.in.readString();
                    String typ = this.in.readString();
                    qp.context(val, typ);
                    this.log.write(this, (Object)((Object)sc) + "(" + arg + ')', val, typ, "OK", this.perf);
                } else if (sc == ServerCmd.ITER) {
                    qp.execute(true, this.out, true, false);
                } else if (sc == ServerCmd.EXEC) {
                    qp.execute(false, this.out, true, false);
                } else if (sc == ServerCmd.FULL) {
                    qp.execute(true, this.out, true, true);
                } else if (sc == ServerCmd.INFO) {
                    this.out.print(qp.info());
                } else if (sc == ServerCmd.OPTIONS) {
                    this.out.print(qp.options());
                } else if (sc == ServerCmd.UPDATING) {
                    this.out.print(Boolean.toString(qp.updating()));
                } else if (sc == ServerCmd.CLOSE) {
                    this.queries.remove(arg);
                } else if (sc == ServerCmd.NEXT) {
                    throw new Exception("Protocol for query iteration is out-of-dated.");
                }
                this.out.write(0);
            }
            this.out.write(0);
            if (sc != ServerCmd.BIND && sc != ServerCmd.CONTEXT) {
                this.log.write(this, (Object)((Object)sc) + "(" + arg + ')', "OK", this.perf);
            }
        }
        catch (Throwable ex) {
            err = ex.getMessage();
            this.log.write(this, (Object)((Object)sc) + "(" + arg + ')', Text.ERROR_C + err);
            this.queries.remove(arg);
        }
        if (err != null) {
            this.out.write(0);
            this.out.write(1);
            this.out.writeString(err);
        }
        this.out.flush();
    }

    void send(boolean ok) throws IOException {
        this.out.write(ok ? 0 : 1);
        this.out.flush();
    }
}

