/*
 * Decompiled with CFR 0.152.
 */
package org.basex.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.cmd.Add;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Exit;
import org.basex.core.cmd.Replace;
import org.basex.core.cmd.Store;
import org.basex.core.parse.CommandParser;
import org.basex.query.QueryException;
import org.basex.server.LocalQuery;
import org.basex.server.LoginException;
import org.basex.server.Session;
import org.basex.util.Token;
import org.basex.util.Util;

public class LocalSession
extends Session {
    protected final Context ctx;

    public LocalSession(Context context) {
        this(context, null);
    }

    public LocalSession(Context context, String user, String pass) throws LoginException {
        this(context, user, pass, null);
    }

    public LocalSession(Context context, String user, String pass, OutputStream output) throws LoginException {
        this(context, output);
        this.ctx.user = this.ctx.users.get(user);
        if (this.ctx.user == null || !this.ctx.user.password.equals(Token.md5(pass))) {
            throw new LoginException();
        }
    }

    public LocalSession(Context context, OutputStream output) {
        super(output);
        this.ctx = new Context(context, null);
        this.ctx.user = context.user;
    }

    @Override
    public void create(String name, InputStream input) throws IOException {
        this.execute((Command)new CreateDB(name), input);
    }

    @Override
    public void add(String path, InputStream input) throws IOException {
        this.execute((Command)new Add(path), input);
    }

    @Override
    public void replace(String path, InputStream input) throws IOException {
        this.execute((Command)new Replace(path), input);
    }

    @Override
    public void store(String path, InputStream input) throws IOException {
        this.execute((Command)new Store(path), input);
    }

    private void execute(Command cmd, InputStream input) throws BaseXException {
        cmd.setInput(input);
        cmd.execute(this.ctx);
        this.info = cmd.info();
    }

    @Override
    public LocalQuery query(String query) throws BaseXException {
        return new LocalQuery(query, this.ctx, this.out);
    }

    @Override
    public synchronized void close() {
        try {
            this.execute(new Exit());
        }
        catch (IOException ex) {
            Util.debug(ex);
        }
    }

    @Override
    protected void execute(String str, OutputStream os) throws BaseXException {
        try {
            this.execute(new CommandParser(str, this.ctx).parseSingle(), os);
        }
        catch (QueryException ex) {
            throw new BaseXException(ex);
        }
    }

    @Override
    protected void execute(Command cmd, OutputStream os) throws BaseXException {
        cmd.execute(this.ctx, os);
        this.info = cmd.info();
    }
}

