/*
 * Decompiled with CFR 0.152.
 */
package org.basex.server;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.Progress;
import org.basex.core.ProgressException;
import org.basex.core.Text;
import org.basex.io.out.EncodingOutput;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerProp;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;
import org.basex.util.Performance;
import org.basex.util.TokenBuilder;

final class QueryListener
extends Progress {
    private final Performance perf = new Performance();
    private final QueryProcessor qp;
    private final Context ctx;
    private String info = "";
    private SerializerProp options;
    private boolean closed;

    QueryListener(String qu, Context c) {
        this.qp = new QueryProcessor(qu, c);
        this.ctx = c;
    }

    void bind(String n, Object v, String t) throws IOException {
        this.check();
        try {
            this.qp.bind(n, v, t);
        }
        catch (QueryException ex) {
            throw new BaseXException(ex);
        }
    }

    void context(Object v, String t) throws IOException {
        this.check();
        try {
            this.qp.context(v, t);
        }
        catch (QueryException ex) {
            throw new BaseXException(ex);
        }
    }

    String info() {
        return this.info;
    }

    String options() throws IOException {
        this.init();
        return this.options.toString();
    }

    boolean updating() throws IOException {
        this.init();
        return this.qp.updating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(boolean iter, OutputStream out, boolean enc, boolean full) throws IOException {
        this.check();
        try {
            this.init();
            try {
                Item it;
                this.ctx.register(this.qp);
                Iter ir = this.qp.iter();
                boolean wrap = !this.options.get(SerializerProp.S_WRAP_PREFIX).isEmpty();
                PrintOutput po = PrintOutput.get(enc ? new EncodingOutput(out) : out);
                if (iter && wrap) {
                    po.write(1);
                }
                Serializer ser = Serializer.get(po, full ? null : this.options);
                int c = 0;
                while ((it = ir.next()) != null) {
                    if (iter && !wrap) {
                        if (full) {
                            po.write(it.xdmInfo());
                        } else {
                            po.write(it.typeId());
                        }
                        ser.reset();
                    }
                    ser.serialize(it);
                    if (iter && !wrap) {
                        po.flush();
                        out.write(0);
                    }
                    ++c;
                }
                ser.close();
                if (iter && wrap) {
                    out.write(0);
                }
                int up = this.qp.updates();
                TokenBuilder tb = new TokenBuilder();
                tb.addExt(Text.HITS_X_CC + "% %" + Text.NL, c, c == 1 ? "Item" : "Items");
                tb.addExt(Text.UPDATED_CC + "% %" + Text.NL, up, up == 1 ? "Item" : "Items");
                tb.addExt(Text.TOTAL_TIME_CC + '%', this.perf);
                this.info = tb.toString();
            }
            catch (QueryException ex) {
                throw new BaseXException(ex);
            }
            catch (ProgressException ex) {
                throw new BaseXException(Text.TIMEOUT_EXCEEDED, new Object[0]);
            }
            finally {
                this.ctx.unregister(this.qp);
            }
        }
        finally {
            this.qp.close();
            this.closed = true;
        }
    }

    private void init() throws IOException {
        if (this.options != null) {
            return;
        }
        try {
            this.check();
            this.qp.parse();
        }
        catch (QueryException ex) {
            throw new BaseXException(ex);
        }
        this.options = this.qp.ctx.serParams(false);
    }

    private void check() throws IOException {
        if (this.closed) {
            throw new BaseXException(Text.ALREADY_EXECUTED, new Object[0]);
        }
    }
}

