/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.parse.PasswordReader;
import org.basex.util.Reflect;
import org.basex.util.Token;
import org.basex.util.Util;

public abstract class ConsoleReader {
    private static final String DEFAULT_PROMPT = "> ";
    static final String PASSWORD_PROMPT = Text.PASSWORD + ": ";
    private final PasswordReader passwordReader = new PasswordReader(){

        @Override
        public String password() {
            return Token.md5(ConsoleReader.this.readPassword());
        }
    };

    protected ConsoleReader() {
    }

    public abstract String readLine();

    public abstract String readPassword();

    public PasswordReader getPasswordReader() {
        return this.passwordReader;
    }

    public static final ConsoleReader newInstance() {
        if (JLineConsoleReader.isAvailable()) {
            try {
                return new JLineConsoleReader();
            }
            catch (Exception ex) {
                Util.errln(ex, new Object[0]);
            }
        }
        return new SimpleConsoleReader();
    }

    private static class JLineConsoleReader
    extends ConsoleReader {
        private static final String JLINE_CONSOLE_READER = "jline.ConsoleReader";
        private static final String JLINE_HISTORY = "jline.History";
        private static final String HISTORY_FILE = ".basexhistory";
        private static final Character PASSWORD_ECHO = Character.valueOf('\u0000');
        private final Class<?> consoleReaderClass = Reflect.find("jline.ConsoleReader");
        private final Method readLine = Reflect.method(this.consoleReaderClass, "readLine", new Class[0]);
        private final Method readEcho = Reflect.method(this.consoleReaderClass, "readLine", String.class, Character.class);
        private final Method setDefaultPrompt = Reflect.method(this.consoleReaderClass, "setDefaultPrompt", String.class);
        private final Object reader = this.consoleReaderClass.newInstance();

        static boolean isAvailable() {
            return Reflect.available(JLINE_CONSOLE_READER, new Object[0]);
        }

        JLineConsoleReader() throws Exception {
            this.defaultConfiguration();
        }

        private void defaultConfiguration() {
            Class<?> historyClass = Reflect.find(JLINE_HISTORY);
            File hist = new File(Prop.HOME, HISTORY_FILE);
            Object history = Reflect.get(Reflect.find(historyClass, File.class), hist);
            Reflect.invoke(Reflect.method(this.consoleReaderClass, "setUseHistory", Boolean.TYPE), this.reader, true);
            Reflect.invoke(Reflect.method(this.consoleReaderClass, "setBellEnabled", Boolean.TYPE), this.reader, false);
            Reflect.invoke(Reflect.method(this.consoleReaderClass, "setHistory", historyClass), this.reader, history);
            this.restoreDefaultPrompt();
        }

        private void restoreDefaultPrompt() {
            Reflect.invoke(this.setDefaultPrompt, this.reader, ConsoleReader.DEFAULT_PROMPT);
        }

        @Override
        public String readLine() {
            return (String)Reflect.invoke(this.readLine, this.reader, new Object[0]);
        }

        @Override
        public String readPassword() {
            String pw = (String)Reflect.invoke(this.readEcho, this.reader, PASSWORD_PROMPT, PASSWORD_ECHO);
            this.restoreDefaultPrompt();
            return pw;
        }
    }

    private static class SimpleConsoleReader
    extends ConsoleReader {
        private final BufferedReader in = new BufferedReader(new InputStreamReader(System.in));

        SimpleConsoleReader() {
        }

        @Override
        public String readLine() {
            try {
                Util.out(ConsoleReader.DEFAULT_PROMPT, new Object[0]);
                return this.in.readLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String readPassword() {
            Util.out(PASSWORD_PROMPT, new Object[0]);
            return Util.password();
        }
    }
}

