/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import org.basex.util.Token;

public final class Levenshtein {
    private static final int MAX = 50;
    private int[][] matrix;

    public boolean similar(byte[] token, byte[] sub, int err) {
        int sl = 0;
        int tl = 0;
        for (int s = 0; s < sub.length; s += Token.cl(sub, s)) {
            ++sl;
        }
        for (int t = 0; t < token.length; t += Token.cl(token, t)) {
            ++tl;
        }
        if (tl == 0) {
            return false;
        }
        if (sl < 4 || tl > 50 || sl > 50) {
            return sl == tl && Levenshtein.same(token, sub);
        }
        int k = err == 0 ? Math.max(1, sl >> 2) : err;
        return Math.abs(sl - tl) <= k && this.ls(token, tl, sub, sl, k);
    }

    private boolean ls(byte[] tk, int tl, byte[] sb, int sl, int k) {
        int[][] m = this.matrix;
        if (m == null) {
            m = new int[52][52];
            for (int i = 0; i < m.length; ++i) {
                m[0][i] = i;
                m[i][0] = i;
            }
            this.matrix = m;
        }
        int e2 = -1;
        int f2 = -1;
        for (int t = 0; t < tl; t += Token.cl(tk, t)) {
            int e = Token.norm(Token.lc(Token.cp(tk, t)));
            int d = Integer.MAX_VALUE;
            for (int s = 0; s < sl; s += Token.cl(sb, s)) {
                int f = Token.norm(Token.lc(Token.cp(sb, s)));
                int c = Levenshtein.m(m[t][s + 1] + 1, m[t + 1][s] + 1, m[t][s] + (e == f ? 0 : 1));
                if (e == f2 && f == e2) {
                    c = m[t][s];
                }
                m[t + 1][s + 1] = c;
                d = Math.min(d, c);
                f2 = f;
            }
            if (d > k) {
                return false;
            }
            e2 = e;
        }
        return m[tl][sl] <= k;
    }

    private static int m(int a, int b, int c) {
        int d = a < b ? a : b;
        return d < c ? d : c;
    }

    private static boolean same(byte[] tk, byte[] sb) {
        int t = 0;
        for (int s = 0; t < tk.length && s < sb.length; t += Token.cl(tk, t), s += Token.cl(sb, s)) {
            if (Token.lc(Token.norm(Token.cp(tk, t))) == Token.lc(Token.norm(Token.cp(sb, t)))) continue;
            return false;
        }
        return true;
    }
}

