/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.basex.util.Util;

public final class Reflect {
    private static final HashMap<String, Constructor<?>> CONS = new HashMap();
    private static final HashMap<String, Class<?>> CLASSES = new HashMap();
    private static final HashMap<String, Field> FIELDS = new HashMap();

    private Reflect() {
    }

    public static boolean available(String pattern, Object ... ext) {
        try {
            Reflect.forName(Util.info(pattern, ext));
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static Class<?> find(String name) {
        Class<?> c = CLASSES.get(name);
        if (c != null) {
            return c;
        }
        try {
            return Reflect.forName(name);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static Class<?> forName(String name) throws Throwable {
        return Reflect.cache(name, Class.forName(name));
    }

    private static Class<?> cache(String name, Class<?> c) {
        try {
            if (!Reflect.accessible(c)) {
                return null;
            }
            CLASSES.put(name, c);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return c;
    }

    public static Field field(Class<?> clazz, String name) {
        String key = clazz.getName() + name;
        Field f = FIELDS.get(key);
        if (f == null) {
            try {
                f = clazz.getField(name);
                FIELDS.put(key, f);
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        return f;
    }

    public static Class<?> find(String pattern, Object ... ext) {
        return Reflect.find(Util.info(pattern, ext));
    }

    public static Class<?> find(String[] names) {
        for (String n : names) {
            Class<?> c = Reflect.find(n);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    public static Constructor<?> find(Class<?> clazz, Class<?> ... types) {
        if (clazz == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(clazz.getName());
        for (Class<?> c : types) {
            sb.append(c.getName());
        }
        String key = sb.toString();
        Constructor<?> m = CONS.get(key);
        if (m == null) {
            try {
                try {
                    m = clazz.getConstructor(types);
                }
                catch (Throwable ex) {
                    m = clazz.getDeclaredConstructor(types);
                    m.setAccessible(true);
                }
                CONS.put(key, m);
            }
            catch (Throwable ex) {
                Util.debug(ex);
            }
        }
        return m;
    }

    public static Method method(Class<?> clazz, String name, Class<?> ... types) {
        if (clazz == null) {
            return null;
        }
        Method m = null;
        try {
            try {
                m = clazz.getMethod(name, types);
            }
            catch (Throwable ex) {
                m = clazz.getDeclaredMethod(name, types);
                m.setAccessible(true);
            }
        }
        catch (Throwable ex) {
            Util.debug(ex);
        }
        return m;
    }

    public static Object get(Class<?> clazz) {
        try {
            return clazz != null ? clazz.newInstance() : null;
        }
        catch (Throwable ex) {
            Util.debug(ex);
            return null;
        }
    }

    public static Object get(Constructor<?> clazz, Object ... args) {
        try {
            return clazz != null ? clazz.newInstance(args) : null;
        }
        catch (Throwable ex) {
            Util.debug(ex);
            return null;
        }
    }

    public static Object invoke(Method method, Object object, Object ... args) {
        try {
            return method != null ? method.invoke(object, args) : null;
        }
        catch (Throwable ex) {
            Util.debug(ex);
            return null;
        }
    }

    private static boolean accessible(Class<?> cls) {
        return Modifier.isPublic(cls.getModifiers());
    }
}

