/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Scanner;
import org.basex.core.Text;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.BoolList;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class Table {
    private static final int DIST = 2;
    public final TokenList header = new TokenList();
    public final BoolList align = new BoolList();
    public final ArrayList<TokenList> contents = new ArrayList();
    public String description;

    public Table() {
    }

    public Table(String in) {
        if (in.isEmpty()) {
            return;
        }
        Scanner scan = new Scanner(in);
        byte[] line = Token.token(scan.nextLine());
        IntList il = new IntList();
        int i = 0;
        while (i < line.length) {
            il.add(i);
            while (++i + 1 < line.length && (line[i] != 32 || line[i + 1] != 32)) {
            }
            this.header.add(Token.substring(line, il.get(il.size() - 1), i));
            while (++i < line.length && line[i] == 32) {
            }
        }
        il.add(i);
        scan.nextLine();
        int s = il.size() - 1;
        while ((line = Token.token(scan.nextLine())).length != 0) {
            TokenList entry = new TokenList();
            for (int e = 0; e < s; ++e) {
                entry.add(Token.trim(Token.substring(line, il.get(e), il.get(e + 1))));
            }
            this.contents.add(entry);
        }
    }

    public Table sort() {
        Collections.sort(this.contents, new Comparator<TokenList>(){

            @Override
            public int compare(TokenList tl1, TokenList tl2) {
                return Token.diff(Token.lc(tl1.get(0)), Token.lc(tl2.get(0)));
            }
        });
        return this;
    }

    public String value(int r, int c) {
        return Token.string(this.contents.get(r).get(c));
    }

    public int rows() {
        return this.contents.size();
    }

    public int cols() {
        return this.header.size();
    }

    public Table toTop(byte[] top) {
        for (int i = 0; i < this.contents.size(); ++i) {
            if (!Token.eq(top, this.contents.get(i).get(0))) continue;
            this.contents.add(0, this.contents.remove(i));
            break;
        }
        return this;
    }

    public byte[] finish() {
        int u;
        int[] ind = new int[this.header.size()];
        int sz = this.header.size();
        for (int s = 0; s < sz; ++s) {
            for (TokenList e : this.contents) {
                ind[s] = Math.max(ind[s], e.get(s).length);
            }
            ind[s] = Math.max(ind[s], this.header.get(s).length);
        }
        TokenBuilder tb = new TokenBuilder();
        for (u = 0; u < sz; ++u) {
            byte[] s = this.header.get(u);
            int is = ind[u] - s.length + 2;
            tb.add(s);
            for (int i = 0; i < is; ++i) {
                tb.add(32);
            }
        }
        tb.add(Text.NL);
        for (u = 0; u < sz; ++u) {
            for (int i = 0; i < ind[u] + (u + 1 == sz ? 0 : 2); ++i) {
                tb.add(45);
            }
        }
        tb.add(Text.NL);
        for (TokenList e : this.contents) {
            for (int u2 = 0; u2 < sz; ++u2) {
                int i;
                byte[] s = e.get(u2);
                int is = ind[u2] - s.length;
                if (u2 < this.align.size() && this.align.get(u2)) {
                    for (i = 0; i < is; ++i) {
                        tb.add(32);
                    }
                    tb.add(s);
                } else {
                    tb.add(s);
                    for (i = 0; i < is; ++i) {
                        tb.add(32);
                    }
                }
                for (i = 0; i < 2; ++i) {
                    tb.add(32);
                }
            }
            tb.add(Text.NL);
        }
        if (this.description != null) {
            tb.add(Text.NL).add(this.contents.size() + " " + this.description + ".");
        }
        return tb.finish();
    }

    public String toString() {
        TokenBuilder tb = new TokenBuilder();
        for (byte[] b : this.header) {
            tb.add(b);
            tb.add(9);
        }
        tb.add(Text.NL);
        for (TokenList e : this.contents) {
            for (byte[] b : e) {
                tb.add(b);
                tb.add(9);
            }
        }
        return tb.toString();
    }
}

