/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.util.Arrays;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.Util;

public final class TokenBuilder {
    public static final byte HLINE = 1;
    private static final byte BOLD = 2;
    private static final byte NORM = 3;
    public static final byte MARK = 4;
    public static final byte NLINE = 10;
    private byte[] chars;
    private int size;

    public TokenBuilder() {
        this(8);
    }

    public TokenBuilder(int i) {
        this.chars = new byte[i];
    }

    public TokenBuilder(String s) {
        this(Token.token(s));
    }

    public TokenBuilder(byte[] t) {
        this(t.length + 8);
        this.size = t.length;
        System.arraycopy(t, 0, this.chars, 0, this.size);
    }

    public int size() {
        return this.size;
    }

    public void size(int s) {
        this.size = s;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public TokenBuilder reset() {
        this.size = 0;
        return this;
    }

    public TokenBuilder bold() {
        return this.addByte((byte)2);
    }

    public TokenBuilder norm() {
        return this.addByte((byte)3);
    }

    public TokenBuilder nline() {
        return this.addByte((byte)10);
    }

    public TokenBuilder hline() {
        return this.addByte((byte)1);
    }

    public TokenBuilder add(int ch) {
        if (ch <= 127) {
            this.addByte((byte)ch);
        } else if (ch <= 2047) {
            this.addByte((byte)(ch >> 6 & 0x1F | 0xC0));
            this.addByte((byte)(ch & 0x3F | 0x80));
        } else if (ch <= 65535) {
            this.addByte((byte)(ch >> 12 & 0xF | 0xE0));
            this.addByte((byte)(ch >> 6 & 0x3F | 0x80));
            this.addByte((byte)(ch & 0x3F | 0x80));
        } else {
            this.addByte((byte)(ch >> 18 & 7 | 0xF0));
            this.addByte((byte)(ch >> 12 & 0x3F | 0x80));
            this.addByte((byte)(ch >> 6 & 0x3F | 0x80));
            this.addByte((byte)(ch & 0x3F | 0x80));
        }
        return this;
    }

    public TokenBuilder insert(int pos, int ch) {
        int l;
        int s = this.size;
        int cl = this.chars.length;
        int n = ch <= 127 ? 1 : (ch <= 2047 ? 2 : (l = ch <= 4095 ? 3 : 4));
        if (s + l > cl) {
            int ns = Math.max(s + l, (int)((double)cl * 1.5));
            this.chars = Arrays.copyOf(this.chars, ns);
        }
        Array.move(this.chars, pos, l, this.size - pos);
        this.size = pos;
        this.add(ch);
        this.size = s + l;
        return this;
    }

    public int cp(int p) {
        return Token.cp(this.chars, p);
    }

    public int cl(int p) {
        return Token.cl(this.chars, p);
    }

    public byte get(int p) {
        return this.chars[p];
    }

    public void set(byte b, int p) {
        this.chars[p] = b;
    }

    public void delete(int p, int s) {
        Array.move(this.chars, p + s, -s, this.size - p - s);
        this.size -= s;
    }

    public TokenBuilder addByte(byte b) {
        if (this.size == this.chars.length) {
            this.chars = Arrays.copyOf(this.chars, Array.newSize(this.size));
        }
        this.chars[this.size++] = b;
        return this;
    }

    public TokenBuilder addLong(long i) {
        return this.add(Token.token(i));
    }

    public TokenBuilder add(byte[] b) {
        return this.add(b, 0, b.length);
    }

    public TokenBuilder add(byte[] b, int s, int e) {
        int l = e - s;
        int cl = this.chars.length;
        if (this.size + l > cl) {
            int ns = Math.max(this.size + l, (int)((double)cl * 1.5));
            this.chars = Arrays.copyOf(this.chars, ns);
        }
        System.arraycopy(b, s, this.chars, this.size, l);
        this.size += l;
        return this;
    }

    public TokenBuilder add(String s) {
        return this.add(Token.token(s));
    }

    public TokenBuilder addSep(Object[] s, String sep) {
        for (int e = 0; e != s.length; ++e) {
            if (e != 0) {
                this.add(sep);
            }
            this.addExt(s[e], new Object[0]);
        }
        return this;
    }

    public TokenBuilder addExt(Object str, Object ... ext) {
        byte[] t;
        if (str instanceof byte[]) {
            t = (byte[])str;
        } else {
            String s = str == null ? "null" : (str instanceof Throwable ? Util.message((Throwable)str) : (str instanceof Class ? Util.name((Class)str) : str.toString()));
            t = Token.token(s);
        }
        int e = 0;
        for (int i = 0; i < t.length; ++i) {
            boolean d;
            if (t[i] != 37 || e == ext.length) {
                this.addByte(t[i]);
                continue;
            }
            byte c = i + 1 < t.length ? t[i + 1] : (byte)0;
            boolean bl = d = c >= 49 && c <= 57;
            if (d) {
                ++i;
            }
            int n = d ? c - 49 : e++;
            Object o = n < ext.length ? ext[n] : null;
            this.addExt(o, new Object[0]);
        }
        return this;
    }

    public TokenBuilder trim() {
        while (this.size > 0 && Token.ws(this.chars[this.size - 1])) {
            --this.size;
        }
        int s = -1;
        while (++s < this.size && Token.ws(this.chars[s])) {
        }
        if (s != 0 && s != this.size) {
            Array.move(this.chars, s, -s, this.size - s);
        }
        this.size -= s;
        return this;
    }

    public byte[] finish() {
        return Arrays.copyOf(this.chars, this.size);
    }

    public String toString() {
        return Token.string(this.chars, 0, this.size);
    }
}

