/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import org.basex.util.Token;

public final class XMLToken {
    private XMLToken() {
    }

    public static boolean valid(int ch) {
        return ch < 55296 ? ch >= 32 || ch == 10 || ch == 9 || ch == 13 : ch >= 57344 && ch <= 65533 || ch >= 65536 && ch <= 0x10FFFF;
    }

    public static boolean isNCStartChar(int ch) {
        return ch < 128 ? ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch == 95 : (ch < 768 ? ch >= 192 && ch != 215 && ch != 247 : ch >= 880 && ch <= 893 || ch >= 895 && ch <= 8191 || ch >= 8204 && ch <= 8205 || ch >= 8304 && ch <= 8591 || ch >= 11264 && ch <= 12031 || ch >= 12289 && ch <= 55295 || ch >= 63744 && ch <= 64975 || ch >= 65008 && ch <= 65533 || ch >= 65536 && ch <= 983039);
    }

    public static boolean isNCChar(int ch) {
        return XMLToken.isNCStartChar(ch) || (ch < 256 ? Token.digit(ch) || ch == 45 || ch == 46 || ch == 183 : ch >= 768 && ch <= 879 || ch == 8255 || ch == 8256);
    }

    public static boolean isStartChar(int ch) {
        return XMLToken.isNCStartChar(ch) || ch == 58;
    }

    public static boolean isChar(int ch) {
        return XMLToken.isNCChar(ch) || ch == 58;
    }

    public static boolean isNCName(byte[] v) {
        int l = v.length;
        return l != 0 && XMLToken.ncName(v, 0) == l;
    }

    public static boolean isName(byte[] v) {
        int l = v.length;
        for (int i = 0; i < l; i += Token.cl(v, i)) {
            int c = Token.cp(v, i);
            if (!(i == 0 ? !XMLToken.isStartChar(c) : !XMLToken.isChar(c))) continue;
            return false;
        }
        return l != 0;
    }

    public static boolean isNMToken(byte[] v) {
        int l = v.length;
        for (int i = 0; i < l; i += Token.cl(v, i)) {
            if (XMLToken.isChar(Token.cp(v, i))) continue;
            return false;
        }
        return l != 0;
    }

    public static boolean isQName(byte[] val) {
        return XMLToken.isQName(val, 0);
    }

    private static boolean isQName(byte[] v, int p) {
        int l = v.length;
        if (l == p) {
            return false;
        }
        int i = XMLToken.ncName(v, p);
        if (i == l) {
            return true;
        }
        if (i == p || v[i] != 58) {
            return false;
        }
        int j = XMLToken.ncName(v, i + 1);
        return j == l && j != i + 1;
    }

    private static int ncName(byte[] v, int p) {
        int l = v.length;
        for (int i = p; i < l; i += Token.cl(v, i)) {
            int c = Token.cp(v, i);
            if (!(i == p ? !XMLToken.isNCStartChar(c) : !XMLToken.isNCChar(c))) continue;
            return i;
        }
        return l;
    }
}

