/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.util.EnumMap;
import java.util.Map;
import org.basex.data.ExprInfo;
import org.basex.data.MetaData;
import org.basex.query.ft.ThesQuery;
import org.basex.query.value.node.FElem;
import org.basex.util.Token;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.Language;
import org.basex.util.ft.StemDir;
import org.basex.util.ft.StopWords;

public final class FTOpt
extends ExprInfo {
    private final EnumMap<FTFlag, Boolean> map = new EnumMap(FTFlag.class);
    public StemDir sd;
    public StopWords sw;
    public ThesQuery th;
    public Language ln;

    public FTOpt copy(FTOpt opt) {
        for (Map.Entry<FTFlag, Boolean> f : opt.map.entrySet()) {
            FTFlag fl = f.getKey();
            if (this.map.get((Object)fl) != null) continue;
            this.map.put(fl, f.getValue());
        }
        if (this.sw == null) {
            this.sw = opt.sw;
        }
        if (this.sd == null) {
            this.sd = opt.sd;
        }
        if (this.ln == null) {
            this.ln = opt.ln;
        }
        if (this.th == null) {
            this.th = opt.th;
        } else if (opt.th != null) {
            this.th.merge(opt.th);
        }
        return this;
    }

    public FTOpt copy(MetaData md) {
        this.set(FTFlag.CS, md.casesens);
        this.set(FTFlag.DC, md.diacritics);
        this.set(FTFlag.ST, md.stemming);
        this.ln = md.language;
        return this;
    }

    public FTOpt set(FTFlag f, boolean v) {
        this.map.put(f, v);
        return this;
    }

    public boolean isSet(FTFlag f) {
        return this.map.get((Object)f) != null;
    }

    public boolean is(FTFlag f) {
        Boolean b = this.map.get((Object)f);
        return b != null && b != false;
    }

    @Override
    public void plan(FElem plan) {
        if (this.is(FTFlag.WC)) {
            plan.add(this.planAttr("wildcards", Token.TRUE));
        }
        if (this.is(FTFlag.FZ)) {
            plan.add(this.planAttr("fuzzy", Token.TRUE));
        }
        if (this.is(FTFlag.UC)) {
            plan.add(this.planAttr("uppercase", Token.TRUE));
        }
        if (this.is(FTFlag.LC)) {
            plan.add(this.planAttr("lowercase", Token.TRUE));
        }
        if (this.is(FTFlag.DC)) {
            plan.add(this.planAttr("diacritics", Token.TRUE));
        }
        if (this.is(FTFlag.ST)) {
            plan.add(this.planAttr("stemming", Token.TRUE));
        }
        if (this.ln != null) {
            plan.add(this.planAttr("language", this.ln));
        }
        if (this.th != null) {
            plan.add(this.planAttr("thesaurus", Token.TRUE));
        }
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.is(FTFlag.WC)) {
            s.append(" using wildcards");
        }
        if (this.is(FTFlag.FZ)) {
            s.append(" using fuzzy");
        }
        if (this.is(FTFlag.UC)) {
            s.append(" using uppercase");
        }
        if (this.is(FTFlag.LC)) {
            s.append(" using lowercase");
        }
        if (this.is(FTFlag.DC)) {
            s.append(" using diacritics sensitive");
        }
        if (this.is(FTFlag.ST) || this.sd != null) {
            s.append(" using stemming");
        }
        if (this.ln != null) {
            s.append(" using language '" + this.ln + '\'');
        }
        if (this.th != null) {
            s.append(" using thesaurus");
        }
        return s.toString();
    }
}

