/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.hash;

import java.util.Arrays;

public class IntSet {
    static final int CAP = 8;
    int size = 1;
    int[] keys = new int[8];
    private int[] next = new int[8];
    private int[] bucket = new int[8];

    public final int add(int key) {
        if (this.size == this.next.length) {
            this.rehash();
        }
        int p = key & this.bucket.length - 1;
        int id = this.bucket[p];
        while (id != 0) {
            if (key == this.keys[id]) {
                return -id;
            }
            id = this.next[id];
        }
        this.next[this.size] = this.bucket[p];
        this.keys[this.size] = key;
        this.bucket[p] = this.size;
        return this.size++;
    }

    public final int id(int key) {
        int p = key & this.bucket.length - 1;
        int id = this.bucket[p];
        while (id != 0) {
            if (key == this.keys[id]) {
                return id;
            }
            id = this.next[id];
        }
        return 0;
    }

    public final int key(int i) {
        return this.keys[i];
    }

    public final int size() {
        return this.size - 1;
    }

    void rehash() {
        int s = this.size << 1;
        int[] tmp = new int[s];
        int l = this.bucket.length;
        for (int i = 0; i != l; ++i) {
            int id = this.bucket[i];
            while (id != 0) {
                int p = this.keys[id] & s - 1;
                int nx = this.next[id];
                this.next[id] = tmp[p];
                tmp[p] = id;
                id = nx;
            }
        }
        this.bucket = tmp;
        this.next = Arrays.copyOf(this.next, s);
        int[] k = new int[s];
        System.arraycopy(this.keys, 0, k, 0, this.size);
        this.keys = k;
    }

    public final int delete(int key) {
        int p = key & this.bucket.length - 1;
        int id = this.bucket[p];
        while (id != 0) {
            if (key == this.keys[id]) {
                if (this.bucket[p] == id) {
                    this.bucket[p] = this.next[id];
                } else {
                    this.next[id] = this.next[this.next[id]];
                }
                this.keys[id] = 0;
                return id;
            }
            id = this.next[id];
        }
        return 0;
    }
}

