/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.hash;

import java.io.IOException;
import java.util.Arrays;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.hash.TokenSet;

public final class TokenIntMap
extends TokenSet {
    private int[] values;

    public TokenIntMap() {
        this.values = new int[8];
    }

    public TokenIntMap(DataInput in) throws IOException {
        this.read(in);
    }

    @Override
    public void read(DataInput in) throws IOException {
        super.read(in);
        this.values = in.readNums();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeNums(this.values);
    }

    public void add(byte[] key, int val) {
        int i = this.add(key);
        this.values[Math.abs((int)i)] = val;
    }

    public int value(byte[] key) {
        int id = this.id(key);
        return id == 0 ? -1 : this.values[id];
    }

    @Override
    protected void rehash() {
        super.rehash();
        this.values = Arrays.copyOf(this.values, this.size << 1);
    }
}

