/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import java.util.Arrays;
import org.basex.util.Token;
import org.basex.util.list.ElementList;

public class ByteList
extends ElementList {
    protected byte[] list;

    public ByteList() {
        this(8);
    }

    public ByteList(int c) {
        this.list = new byte[c];
    }

    public ByteList add(int e) {
        if (this.size == this.list.length) {
            this.list = Arrays.copyOf(this.list, this.newSize());
        }
        this.list[this.size++] = (byte)e;
        return this;
    }

    public ByteList add(byte[] b) {
        return this.add(b, 0, b.length);
    }

    public ByteList add(byte[] b, int s, int e) {
        int l = e - s;
        if (this.size + l > this.list.length) {
            this.list = Arrays.copyOf(this.list, this.newSize(this.size + l));
        }
        System.arraycopy(b, s, this.list, this.size, l);
        this.size += l;
        return this;
    }

    public final byte get(int i) {
        return this.list[i];
    }

    public byte[] toArray() {
        return Arrays.copyOf(this.list, this.size);
    }

    public String toString() {
        return Token.string(this.list, 0, this.size);
    }
}

