/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.basex.util.Array;
import org.basex.util.Util;
import org.basex.util.list.ElementList;

public class StringList
extends ElementList
implements Iterable<String> {
    protected String[] list;

    public StringList() {
        this(8);
    }

    public StringList(int c) {
        this.list = new String[c];
    }

    public final StringList add(String e) {
        if (this.size == this.list.length) {
            this.list = Array.copyOf(this.list, this.newSize());
        }
        this.list[this.size++] = e;
        return this;
    }

    public final StringList add(String[] e) {
        for (String s : e) {
            this.add(s);
        }
        return this;
    }

    public final String get(int p) {
        return this.list[p];
    }

    public final void set(int i, String e) {
        if (i >= this.list.length) {
            this.list = Arrays.copyOf(this.list, this.newSize(i + 1));
        }
        this.list[i] = e;
        this.size = Math.max(this.size, i + 1);
    }

    public final boolean contains(String e) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.list[i].equals(e)) continue;
            return true;
        }
        return false;
    }

    public final void deleteAt(int i) {
        Array.move(this.list, i + 1, -1, --this.size - i);
    }

    public final String[] toArray() {
        return Array.copyOf(this.list, this.size);
    }

    public final StringList sort(boolean cs, boolean asc) {
        return this.sort(cs, asc, 0);
    }

    public final StringList sort(boolean cs, boolean asc, int pos) {
        Comparator comp = cs ? null : String.CASE_INSENSITIVE_ORDER;
        Arrays.sort(this.list, pos, this.size, asc ? comp : Collections.reverseOrder(comp));
        return this;
    }

    @Override
    public final Iterator<String> iterator() {
        return new Iterator<String>(){
            private int c;

            @Override
            public boolean hasNext() {
                return this.c < StringList.this.size;
            }

            @Override
            public String next() {
                return StringList.this.list[this.c++];
            }

            @Override
            public void remove() {
                Util.notexpected(new Object[0]);
            }
        };
    }

    public StringList unique() {
        StringList sl = new StringList(this.size);
        if (this.size != 0) {
            sl.add(this.list[0]);
        }
        for (int s = 1; s < this.size(); ++s) {
            String l = this.list[s];
            if (l.equals(this.list[s - 1])) continue;
            sl.add(l);
        }
        return sl;
    }
}

